/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DayClickedEventData {
    private final ZoneId zoneId;
    private final Instant dayStart;
    private final boolean isDoubleClick;

    public DayClickedEventData(ZoneId zoneId, Instant dayStart, boolean isDoubleClick) {
        this.zoneId = zoneId;
        this.dayStart = dayStart;
        this.isDoubleClick = isDoubleClick;
    }

    public Instant getDayStart() {
        return this.dayStart;
    }

    public LocalDate getDayAsLocalDate() {
        return ZonedDateTime.ofInstant(this.dayStart, this.zoneId).toLocalDate();
    }

    public boolean isDoubleClick() {
        return this.isDoubleClick;
    }
}

