/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiFieldMessagePosition;
import org.teamapps.dto.UiFieldMessageSeverity;
import org.teamapps.dto.UiFieldMessageVisibilityMode;

public class FieldMessage {
    private final Severity severity;
    private final String message;
    private final Position position;
    private final VisibilityMode visibilityMode;

    public FieldMessage(Severity severity, String message) {
        this(Position.BELOW, VisibilityMode.ON_FOCUS, severity, message);
    }

    public FieldMessage(Position position, VisibilityMode visibilityMode, Severity severity, String message) {
        this.position = position;
        this.visibilityMode = visibilityMode;
        this.severity = severity;
        this.message = message;
    }

    public UiFieldMessage createUiFieldMessage() {
        return new UiFieldMessage(this.severity.toUiFieldMessageSeverity(), this.message, this.position.toUiFieldMessagePosition(), this.visibilityMode.toUiFieldMessageVisibilityMode());
    }

    public Position getPosition() {
        return this.position;
    }

    public VisibilityMode getVisibilityMode() {
        return this.visibilityMode;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "FieldMessage{severity=" + this.severity + ", message='" + this.message + "', position=" + this.position + ", visibilityMode=" + this.visibilityMode + "}";
    }

    public static enum VisibilityMode {
        ALWAYS_VISIBLE,
        ON_FOCUS,
        ON_HOVER_OR_FOCUS;


        public UiFieldMessageVisibilityMode toUiFieldMessageVisibilityMode() {
            return UiFieldMessageVisibilityMode.valueOf((String)this.name());
        }
    }

    public static enum Position {
        ABOVE,
        BELOW,
        POPOVER;


        public UiFieldMessagePosition toUiFieldMessagePosition() {
            return UiFieldMessagePosition.valueOf((String)this.name());
        }
    }

    public static enum Severity {
        INFO,
        SUCCESS,
        WARNING,
        ERROR;


        public UiFieldMessageSeverity toUiFieldMessageSeverity() {
            return UiFieldMessageSeverity.valueOf((String)this.name());
        }
    }
}

