/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiTableColumn;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class TableColumn {
    private Table table;
    private final String propertyName;
    private Icon icon;
    private String title;
    private AbstractField field;
    private int minWidth;
    private int defaultWidth = 100;
    private int maxWidth;
    private boolean hidden;
    private boolean sortable = true;
    private boolean resizeable = true;
    boolean hiddenIfOnlyEmptyCellsVisible = false;
    private List<FieldMessage> messages = new ArrayList<FieldMessage>();

    public TableColumn(String propertyName, AbstractField field) {
        this(propertyName, null, null, field, 0, 100, 0);
    }

    public TableColumn(String propertyName, String title, AbstractField field) {
        this(propertyName, null, title, field, 0, 100, 0);
    }

    public TableColumn(String propertyName, Icon icon, String title, AbstractField field) {
        this(propertyName, icon, title, field, 0, 100, 0);
    }

    public TableColumn(String propertyName, Icon icon, String title, AbstractField field, int defaultWidth) {
        this(propertyName, icon, title, field, 0, defaultWidth, 0);
    }

    public TableColumn(String propertyName, Icon icon, String title, AbstractField field, int minWidth, int defaultWidth, int maxWidth) {
        this.propertyName = propertyName;
        this.icon = icon;
        this.title = title;
        this.field = field;
        this.minWidth = minWidth;
        this.defaultWidth = defaultWidth;
        this.maxWidth = maxWidth;
    }

    public UiTableColumn createUiTableColumn() {
        SessionContext context = CurrentSessionContext.get();
        UiTableColumn uiTableColumn = new UiTableColumn(this.propertyName, context.resolveIcon(this.icon), this.title, this.field.createUiComponentReference());
        uiTableColumn.setDefaultWidth(this.defaultWidth);
        uiTableColumn.setMinWidth(this.minWidth);
        uiTableColumn.setDefaultWidth(this.defaultWidth);
        uiTableColumn.setMaxWidth(this.maxWidth);
        uiTableColumn.setSortable(this.sortable);
        uiTableColumn.setResizeable(this.resizeable);
        uiTableColumn.setHiddenIfOnlyEmptyCellsVisible(this.hiddenIfOnlyEmptyCellsVisible);
        uiTableColumn.setMessages(this.messages.stream().map(fieldMessage -> fieldMessage.createUiFieldMessage()).collect(Collectors.toList()));
        return uiTableColumn;
    }

    public List<FieldMessage> getMessages() {
        return this.messages;
    }

    public void addMessage(FieldMessage message) {
        this.messages.add(message);
        if (this.table != null) {
            this.table.updateColumnMessages(this);
        }
    }

    public void removeMessage(FieldMessage message) {
        this.messages.remove(message);
        if (this.table != null) {
            this.table.updateColumnMessages(this);
        }
    }

    public void setMessages(List<FieldMessage> messages) {
        this.messages = messages;
        if (this.table != null) {
            this.table.updateColumnMessages(this);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public TableColumn setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public TableColumn setTitle(String title) {
        this.title = title;
        return this;
    }

    public AbstractField getField() {
        return this.field;
    }

    public TableColumn setField(AbstractField field) {
        this.field = field;
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public TableColumn setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public TableColumn setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public TableColumn setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public TableColumn setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public TableColumn setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public TableColumn setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
        return this;
    }

    public boolean isHiddenIfOnlyEmptyCellsVisible() {
        return this.hiddenIfOnlyEmptyCellsVisible;
    }

    public TableColumn setHiddenIfOnlyEmptyCellsVisible(boolean hiddenIfOnlyEmptyCellsVisible) {
        this.hiddenIfOnlyEmptyCellsVisible = hiddenIfOnlyEmptyCellsVisible;
        return this;
    }

    void setTable(Table table) {
        this.table = table;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

