/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.AbstractFilter;
import org.teamapps.data.value.filter.FilterType;

public class NumericFilter
extends AbstractFilter {
    private final double value;
    private final Comparator comparator;

    public NumericFilter(String property, double value, Comparator comparator) {
        super(property);
        this.value = value;
        this.comparator = comparator;
    }

    @Override
    public FilterType getType() {
        return FilterType.NUMERIC;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        Number recordValue = (Number)record.getValue(this.getProperty());
        double matchValue = 0.0;
        if (recordValue != null) {
            matchValue = recordValue.doubleValue();
        }
        if (!treatNullAsDefaultValue && recordValue == null) {
            return false;
        }
        switch (this.comparator) {
            case EQUAL: {
                return matchValue == this.value;
            }
            case UNEQUAL: {
                return matchValue != this.value;
            }
            case SMALLER: {
                return matchValue < this.value;
            }
            case SMALLER_OR_EQUAL: {
                return matchValue <= this.value;
            }
            case GREATER: {
                return matchValue > this.value;
            }
            case GREATER_OR_EQUAL: {
                return matchValue >= this.value;
            }
        }
        return false;
    }

    @Override
    public String explain(int filterLevel) {
        return this.createLevelIndentString(filterLevel) + "NUMERIC: " + this.getProperty() + " " + this.comparator.name() + " " + String.format("%1.2f", this.value) + "\n";
    }

    public Double getValue() {
        return this.value;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public int getValueAsInt() {
        return new Double(this.value).intValue();
    }

    public long getValueAsLong() {
        return new Double(this.value).longValue();
    }

    public static enum Comparator {
        EQUAL,
        UNEQUAL,
        SMALLER,
        SMALLER_OR_EQUAL,
        GREATER,
        GREATER_OR_EQUAL;

    }
}

