/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiCalendar;
import org.teamapps.dto.UiCalendarEventClientRecord;
import org.teamapps.dto.UiCalendarEventRenderingStyle;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiWeekDay;
import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.calendar.CalendarEvent;
import org.teamapps.ux.component.calendar.CalendarEventTemplateDecider;
import org.teamapps.ux.component.calendar.CalendarModel;
import org.teamapps.ux.component.calendar.CalendarViewMode;
import org.teamapps.ux.component.calendar.DayClickedEventData;
import org.teamapps.ux.component.calendar.EventClickedEventData;
import org.teamapps.ux.component.calendar.EventMovedEventData;
import org.teamapps.ux.component.calendar.IntervalSelectedEventData;
import org.teamapps.ux.component.calendar.ViewChangedEventData;
import org.teamapps.ux.component.calendar.WeeHeaderClickedEventData;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.session.CurrentSessionContext;

public class Calendar<CEVENT extends CalendarEvent>
extends AbstractComponent {
    private final Logger LOGGER = LoggerFactory.getLogger(Calendar.class);
    public final Event<EventClickedEventData<CEVENT>> onEventClicked = new Event();
    public final Event<EventMovedEventData<CEVENT>> onEventMoved = new Event();
    public final Event<DayClickedEventData> onDayClicked = new Event();
    public final Event<IntervalSelectedEventData> onIntervalSelected = new Event();
    public final Event<ViewChangedEventData> onViewChanged = new Event();
    public final Event<LocalDate> onMonthHeaderClicked = new Event();
    public final Event<WeeHeaderClickedEventData> onWeekHeaderClicked = new Event();
    public final Event<LocalDate> onDayHeaderClicked = new Event();
    private CalendarModel<CEVENT> model;
    private PropertyExtractor<CEVENT> propertyExtractor = new BeanPropertyExtractor<CEVENT>();
    private ClientRecordCache<CEVENT, UiCalendarEventClientRecord> recordCache = new ClientRecordCache<CalendarEvent, UiCalendarEventClientRecord>(this::createUiCalendarEventClientRecord);
    private CalendarEventTemplateDecider<CEVENT> templateDecider = this.createStaticTemplateDecider(BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES, BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES);
    private int templateIdCounter = 0;
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private CalendarViewMode activeViewMode = CalendarViewMode.MONTH;
    private LocalDate displayedDate = LocalDate.now();
    private boolean showHeader = false;
    private boolean tableBorder = false;
    private boolean showWeekNumbers = true;
    private int businessHoursStart = 8;
    private int businessHoursEnd = 17;
    private DayOfWeek firstDayOfWeek = CurrentSessionContext.get().getConfiguration().getFirstDayOfWeek();
    private List<DayOfWeek> workingDays = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    private Color tableHeaderBackgroundColor;
    private Color defaultBackgroundColor = new Color(154, 204, 228);
    private Color defaultBorderColor = new Color(154, 204, 228);
    private int minYearViewMonthTileWidth = 175;
    private int maxYearViewMonthTileWidth = 0;
    private ZoneId timeZone = this.getSessionContext().getTimeZone();
    private boolean navigateOnHeaderClicks = true;
    private Consumer<Void> onCalendarDataChangedListener = aVoid -> this.refreshEvents();

    public Calendar() {
        this(null);
    }

    public Calendar(CalendarModel<CEVENT> model) {
        if (model != null) {
            this.setModel(model);
        }
    }

    private UiCalendarEventClientRecord createUiCalendarEventClientRecord(CEVENT calendarEvent) {
        Template timeGridTemplate = this.getTemplateForRecord(calendarEvent, CalendarViewMode.WEEK);
        Template dayGridTemplate = this.getTemplateForRecord(calendarEvent, CalendarViewMode.MONTH);
        Template monthGridTemplate = this.getTemplateForRecord(calendarEvent, CalendarViewMode.YEAR);
        HashSet<String> dataKeys = new HashSet<String>();
        if (timeGridTemplate != null) {
            dataKeys.addAll(timeGridTemplate.getDataKeys());
        }
        if (dayGridTemplate != null) {
            dataKeys.addAll(dayGridTemplate.getDataKeys());
        }
        if (monthGridTemplate != null) {
            dataKeys.addAll(monthGridTemplate.getDataKeys());
        }
        Map<String, Object> values = this.propertyExtractor.getValues(calendarEvent, dataKeys);
        UiCalendarEventClientRecord uiRecord = new UiCalendarEventClientRecord();
        uiRecord.setValues(values);
        uiRecord.setTimeGridTemplateId(this.templateIdsByTemplate.get(timeGridTemplate));
        uiRecord.setDayGridTemplateId(this.templateIdsByTemplate.get(dayGridTemplate));
        uiRecord.setMonthGridTemplateId(this.templateIdsByTemplate.get(monthGridTemplate));
        uiRecord.setIcon(this.getSessionContext().resolveIcon(calendarEvent.getIcon()));
        uiRecord.setTitle(calendarEvent.getTitle());
        uiRecord.setStart(calendarEvent.getStart());
        uiRecord.setEnd(calendarEvent.getEnd());
        uiRecord.setAllDay(calendarEvent.isAllDay());
        uiRecord.setAllowDragOperations(calendarEvent.isAllowDragOperations());
        uiRecord.setBackgroundColor(calendarEvent.getBackgroundColor() != null ? UiUtil.createUiColor(calendarEvent.getBackgroundColor()) : null);
        uiRecord.setBorderColor(calendarEvent.getBorderColor() != null ? UiUtil.createUiColor(calendarEvent.getBorderColor()) : null);
        uiRecord.setRendering(calendarEvent.getRendering() != null ? calendarEvent.getRendering().toUiCalendarEventRenderingStyle() : UiCalendarEventRenderingStyle.DEFAULT);
        return uiRecord;
    }

    private Template getTemplateForRecord(CEVENT record, CalendarViewMode viewMode) {
        Template template = this.templateDecider.getTemplate(record, viewMode);
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String id = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, id);
            this.queueCommandIfRendered(() -> new UiCalendar.RegisterTemplateCommand(this.getId(), id, template.createUiTemplate()));
        }
        return template;
    }

    public void setModel(CalendarModel<CEVENT> model) {
        if (this.model != null) {
            this.unregisterModelEventListeners();
        }
        this.model = model;
        if (model != null) {
            model.onCalendarDataChanged().addListener(this.onCalendarDataChangedListener);
        }
        this.refreshEvents();
    }

    private void unregisterModelEventListeners() {
        this.model.onCalendarDataChanged().removeListener(this.onCalendarDataChangedListener);
    }

    @Override
    public UiComponent createUiComponent() {
        UiCalendar uiCalendar = new UiCalendar();
        this.mapAbstractUiComponentProperties((UiComponent)uiCalendar);
        uiCalendar.setActiveViewMode(this.activeViewMode.toUiCalendarViewMode());
        uiCalendar.setDisplayedDate(this.displayedDate.atStartOfDay(this.timeZone).toInstant().toEpochMilli());
        uiCalendar.setShowHeader(this.showHeader);
        uiCalendar.setTableBorder(this.tableBorder);
        uiCalendar.setShowWeekNumbers(this.showWeekNumbers);
        uiCalendar.setBusinessHoursStart(this.businessHoursStart);
        uiCalendar.setBusinessHoursEnd(this.businessHoursEnd);
        uiCalendar.setFirstDayOfWeek(this.firstDayOfWeek != null ? UiWeekDay.valueOf((String)this.firstDayOfWeek.name()) : null);
        uiCalendar.setWorkingDays(this.workingDays.stream().map(workingDay -> UiWeekDay.valueOf((String)workingDay.name())).collect(Collectors.toList()));
        uiCalendar.setTableHeaderBackgroundColor(this.tableHeaderBackgroundColor != null ? UiUtil.createUiColor(this.tableHeaderBackgroundColor) : null);
        uiCalendar.setNavigateOnHeaderClicks(this.navigateOnHeaderClicks);
        uiCalendar.setTimeZoneId(this.timeZone.getId());
        uiCalendar.setMinYearViewMonthTileWidth(this.minYearViewMonthTileWidth);
        uiCalendar.setMaxYearViewMonthTileWidth(this.maxYearViewMonthTileWidth);
        Instant queryStart = this.activeViewMode.getDisplayStart(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.timeZone).toInstant();
        Instant queryEnd = this.activeViewMode.getDisplayEnd(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.timeZone).toInstant();
        List<CEVENT> initialCalendarEvents = this.query(queryStart, queryEnd);
        CacheManipulationHandle<List<UiCalendarEventClientRecord>> cacheResponse = this.recordCache.replaceRecords(initialCalendarEvents);
        cacheResponse.commit();
        uiCalendar.setInitialData(cacheResponse.getResult());
        uiCalendar.setTemplates(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        return uiCalendar;
    }

    private List<CEVENT> query(Instant queryStart, Instant queryEnd) {
        List<Object> events;
        if (this.model != null) {
            events = this.model.getEventsForInterval(queryStart, queryEnd);
            this.LOGGER.debug("Query: " + queryStart + " - " + queryEnd + " --> events:" + events.size());
        } else {
            events = Collections.emptyList();
        }
        return events;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_CALENDAR_EVENT_CLICKED: {
                UiCalendar.EventClickedEvent clickEvent = (UiCalendar.EventClickedEvent)event;
                CalendarEvent calendarEvent = (CalendarEvent)this.recordCache.getRecordByClientId(clickEvent.getEventId());
                if (calendarEvent == null) break;
                this.onEventClicked.fire(new EventClickedEventData<CalendarEvent>(calendarEvent, clickEvent.getIsDoubleClick()));
                break;
            }
            case UI_CALENDAR_EVENT_MOVED: {
                UiCalendar.EventMovedEvent eventMovedEvent = (UiCalendar.EventMovedEvent)event;
                CalendarEvent calendarEvent = (CalendarEvent)this.recordCache.getRecordByClientId(eventMovedEvent.getEventId());
                if (calendarEvent == null) break;
                this.onEventMoved.fire(new EventMovedEventData<CalendarEvent>(calendarEvent, Instant.ofEpochMilli(eventMovedEvent.getNewStart()), Instant.ofEpochMilli(eventMovedEvent.getNewEnd())));
                break;
            }
            case UI_CALENDAR_DAY_CLICKED: {
                UiCalendar.DayClickedEvent dayClickedEvent = (UiCalendar.DayClickedEvent)event;
                this.onDayClicked.fire(new DayClickedEventData(this.timeZone, Instant.ofEpochMilli(dayClickedEvent.getDate()), dayClickedEvent.getIsDoubleClick()));
                break;
            }
            case UI_CALENDAR_INTERVAL_SELECTED: {
                UiCalendar.IntervalSelectedEvent selectionEvent = (UiCalendar.IntervalSelectedEvent)event;
                this.onIntervalSelected.fire(new IntervalSelectedEventData(this.timeZone, Instant.ofEpochMilli(selectionEvent.getStart()), Instant.ofEpochMilli(selectionEvent.getEnd()), selectionEvent.getAllDay()));
                break;
            }
            case UI_CALENDAR_VIEW_CHANGED: {
                UiCalendar.ViewChangedEvent viewChangedEvent = (UiCalendar.ViewChangedEvent)event;
                this.displayedDate = Instant.ofEpochMilli(viewChangedEvent.getMainIntervalStart()).atZone(this.timeZone).toLocalDate();
                this.activeViewMode = CalendarViewMode.valueOf(viewChangedEvent.getViewMode().name());
                this.onViewChanged.fire(new ViewChangedEventData(this.timeZone, this.activeViewMode, Instant.ofEpochMilli(viewChangedEvent.getMainIntervalStart()), Instant.ofEpochMilli(viewChangedEvent.getMainIntervalEnd()), Instant.ofEpochMilli(viewChangedEvent.getDisplayedIntervalStart()), Instant.ofEpochMilli(viewChangedEvent.getDisplayedIntervalEnd())));
                break;
            }
            case UI_CALENDAR_DATA_NEEDED: {
                UiCalendar.DataNeededEvent dataNeededEvent = (UiCalendar.DataNeededEvent)event;
                Instant queryStart = Instant.ofEpochMilli(dataNeededEvent.getRequestIntervalStart());
                Instant queryEnd = Instant.ofEpochMilli(dataNeededEvent.getRequestIntervalEnd());
                this.queryAndSendCalendarData(queryStart, queryEnd);
                break;
            }
            case UI_CALENDAR_MONTH_HEADER_CLICKED: {
                UiCalendar.MonthHeaderClickedEvent clickEvent = (UiCalendar.MonthHeaderClickedEvent)event;
                LocalDate startOfMonth = Instant.ofEpochMilli(clickEvent.getMonthStartDate()).atZone(this.timeZone).toLocalDate();
                this.onMonthHeaderClicked.fire(startOfMonth);
                break;
            }
            case UI_CALENDAR_WEEK_HEADER_CLICKED: {
                UiCalendar.WeekHeaderClickedEvent clickEvent = (UiCalendar.WeekHeaderClickedEvent)event;
                LocalDate startOfWeek = Instant.ofEpochMilli(clickEvent.getWeekStartDate()).atZone(this.timeZone).toLocalDate();
                this.onWeekHeaderClicked.fire(new WeeHeaderClickedEventData(this.timeZone, clickEvent.getYear(), clickEvent.getWeek(), startOfWeek));
                break;
            }
            case UI_CALENDAR_DAY_HEADER_CLICKED: {
                UiCalendar.DayHeaderClickedEvent clickEvent = (UiCalendar.DayHeaderClickedEvent)event;
                LocalDate date = Instant.ofEpochMilli(clickEvent.getDate()).atZone(this.timeZone).toLocalDate();
                this.onDayHeaderClicked.fire(date);
                break;
            }
        }
    }

    private void queryAndSendCalendarData(Instant queryStart, Instant queryEnd) {
        List<CEVENT> calendarEvents = this.query(queryStart, queryEnd);
        CacheManipulationHandle<List<UiCalendarEventClientRecord>> cacheResponse = this.recordCache.replaceRecords(calendarEvents);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiCalendar.SetCalendarDataCommand(this.getId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
        } else {
            cacheResponse.commit();
        }
    }

    public ToolbarButtonGroup createViewModesToolbarButtonGroup() {
        ToolbarButtonGroup group = new ToolbarButtonGroup();
        ToolbarButton yearViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.EVENT_NOTE, "Year", "12 Months Overview"));
        yearViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.YEAR));
        group.addButton(yearViewButton);
        ToolbarButton monthViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.DATE_RANGE, "Month", "Full Month View"));
        monthViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.MONTH));
        group.addButton(monthViewButton);
        ToolbarButton weekViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.VIEW_WEEK, "Week", "Week View"));
        weekViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.WEEK));
        group.addButton(weekViewButton);
        ToolbarButton dayViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.VIEW_DAY, "Day", "Single Day View"));
        dayViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.DAY));
        group.addButton(dayViewButton);
        return group;
    }

    public ToolbarButtonGroup createNavigationButtonGroup() {
        ToolbarButtonGroup group = new ToolbarButtonGroup();
        ToolbarButton forwardButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.NAVIGATE_BEFORE, "Previous", null));
        forwardButton.onClick.addListener(toolbarButtonClickEvent -> this.setDisplayedDate(this.activeViewMode.decrement(this.displayedDate)));
        group.addButton(forwardButton);
        ToolbarButton backButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.NAVIGATE_NEXT, "Next", null));
        backButton.onClick.addListener(toolbarButtonClickEvent -> this.setDisplayedDate(this.activeViewMode.increment(this.displayedDate)));
        group.addButton(backButton);
        return group;
    }

    public void refreshEvents() {
        Instant queryStart = this.activeViewMode.getDisplayStart(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.timeZone).toInstant();
        Instant queryEnd = this.activeViewMode.getDisplayEnd(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.timeZone).toInstant();
        this.queryAndSendCalendarData(queryStart, queryEnd);
    }

    public CalendarModel getModel() {
        return this.model;
    }

    public CalendarViewMode getActiveViewMode() {
        return this.activeViewMode;
    }

    public void setActiveViewMode(CalendarViewMode activeViewMode) {
        this.activeViewMode = activeViewMode;
        this.queueCommandIfRendered(() -> new UiCalendar.SetViewModeCommand(this.getId(), activeViewMode.toUiCalendarViewMode()));
        this.refreshEvents();
    }

    public LocalDate getDisplayedDate() {
        return this.displayedDate;
    }

    public void setDisplayedDate(LocalDate displayedDate) {
        this.displayedDate = displayedDate;
        this.queueCommandIfRendered(() -> new UiCalendar.SetDisplayedDateCommand(this.getId(), displayedDate.atStartOfDay(this.timeZone).toInstant().toEpochMilli()));
    }

    public void setDisplayDateOneUnitPrevious() {
        switch (this.getActiveViewMode()) {
            case YEAR: {
                this.setDisplayedDate(this.getDisplayedDate().minusYears(1L));
                break;
            }
            case MONTH: {
                this.setDisplayedDate(this.getDisplayedDate().minusMonths(1L));
                break;
            }
            case WEEK: {
                this.setDisplayedDate(this.getDisplayedDate().minusWeeks(1L));
                break;
            }
            case DAY: {
                this.setDisplayedDate(this.getDisplayedDate().minusDays(1L));
            }
        }
    }

    public void setDisplayDateOneUnitNext() {
        switch (this.getActiveViewMode()) {
            case YEAR: {
                this.setDisplayedDate(this.getDisplayedDate().plusYears(1L));
                break;
            }
            case MONTH: {
                this.setDisplayedDate(this.getDisplayedDate().plusMonths(1L));
                break;
            }
            case WEEK: {
                this.setDisplayedDate(this.getDisplayedDate().plusWeeks(1L));
                break;
            }
            case DAY: {
                this.setDisplayedDate(this.getDisplayedDate().plusDays(1L));
            }
        }
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        this.reRenderIfRendered();
    }

    public boolean isTableBorder() {
        return this.tableBorder;
    }

    public void setTableBorder(boolean tableBorder) {
        this.tableBorder = tableBorder;
        this.reRenderIfRendered();
    }

    public boolean isShowWeekNumbers() {
        return this.showWeekNumbers;
    }

    public void setShowWeekNumbers(boolean showWeekNumbers) {
        this.showWeekNumbers = showWeekNumbers;
        this.reRenderIfRendered();
    }

    public int getBusinessHoursStart() {
        return this.businessHoursStart;
    }

    public void setBusinessHoursStart(int businessHoursStart) {
        this.businessHoursStart = businessHoursStart;
        this.reRenderIfRendered();
    }

    public int getBusinessHoursEnd() {
        return this.businessHoursEnd;
    }

    public void setBusinessHoursEnd(int businessHoursEnd) {
        this.businessHoursEnd = businessHoursEnd;
        this.reRenderIfRendered();
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.reRenderIfRendered();
    }

    public List<DayOfWeek> getWorkingDays() {
        return this.workingDays;
    }

    public void setWorkingDays(List<DayOfWeek> workingDays) {
        this.workingDays = workingDays;
        this.reRenderIfRendered();
    }

    public Color getTableHeaderBackgroundColor() {
        return this.tableHeaderBackgroundColor;
    }

    public void setTableHeaderBackgroundColor(Color tableHeaderBackgroundColor) {
        this.tableHeaderBackgroundColor = tableHeaderBackgroundColor;
        this.reRenderIfRendered();
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
    }

    public Color getDefaultBorderColor() {
        return this.defaultBorderColor;
    }

    public void setDefaultBorderColor(Color defaultBorderColor) {
        this.defaultBorderColor = defaultBorderColor;
    }

    public PropertyExtractor<CEVENT> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<CEVENT> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public CalendarEventTemplateDecider<CEVENT> getTemplateDecider() {
        return this.templateDecider;
    }

    public void setTemplateDecider(CalendarEventTemplateDecider<CEVENT> templateDecider) {
        this.templateDecider = templateDecider;
    }

    public void setTemplates(Template timeGridTemplate, Template dayGridTemplate, Template monthGridTemplate) {
        this.templateDecider = this.createStaticTemplateDecider(timeGridTemplate, dayGridTemplate, monthGridTemplate);
    }

    private CalendarEventTemplateDecider<CEVENT> createStaticTemplateDecider(Template timeGridTemplate, Template dayGridTemplate, Template monthGridTemplate) {
        return (record, viewMode) -> {
            switch (viewMode) {
                case WEEK: 
                case DAY: {
                    return timeGridTemplate;
                }
                case MONTH: {
                    return dayGridTemplate;
                }
                case YEAR: {
                    return monthGridTemplate;
                }
            }
            throw new IllegalArgumentException("Unknown view mode: " + viewMode);
        };
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        this.queueCommandIfRendered(() -> new UiCalendar.SetTimeZoneIdCommand(this.getId(), timeZone.getId()));
    }

    public int getMinYearViewMonthTileWidth() {
        return this.minYearViewMonthTileWidth;
    }

    public void setMinYearViewMonthTileWidth(int minYearViewMonthTileWidth) {
        this.minYearViewMonthTileWidth = minYearViewMonthTileWidth;
        this.reRenderIfRendered();
    }

    public int getMaxYearViewMonthTileWidth() {
        return this.maxYearViewMonthTileWidth;
    }

    public void setMaxYearViewMonthTileWidth(int maxYearViewMonthTileWidth) {
        this.maxYearViewMonthTileWidth = maxYearViewMonthTileWidth;
        this.reRenderIfRendered();
    }

    public boolean isNavigateOnHeaderClicks() {
        return this.navigateOnHeaderClicks;
    }

    public void setNavigateOnHeaderClicks(boolean navigateOnHeaderClicks) {
        this.navigateOnHeaderClicks = navigateOnHeaderClicks;
    }
}

