/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiColorPicker;
import org.teamapps.dto.UiField;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.field.AbstractField;

public class ColorPicker
extends AbstractField<Color> {
    private Color defaultColor = new Color(0, 0, 0);
    private String saveButtonCaption = "Save";
    private String clearButtonCaption = "Clear";

    public UiField createUiComponent() {
        UiColorPicker uiColorPicker = new UiColorPicker();
        this.mapAbstractFieldAttributesToUiField((UiField)uiColorPicker);
        uiColorPicker.setDefaultColor(this.defaultColor != null ? UiUtil.createUiColor(this.defaultColor) : null);
        uiColorPicker.setSaveButtonCaption(this.saveButtonCaption);
        uiColorPicker.setClearButtonCaption(this.clearButtonCaption);
        return uiColorPicker;
    }

    @Override
    public Color convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        UiColor uiColor = (UiColor)value;
        return new Color(uiColor.getRed(), uiColor.getGreen(), uiColor.getBlue(), uiColor.getAlpha());
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public String getSaveButtonCaption() {
        return this.saveButtonCaption;
    }

    public void setSaveButtonCaption(String saveButtonCaption) {
        this.saveButtonCaption = saveButtonCaption;
    }

    public String getClearButtonCaption() {
        return this.clearButtonCaption;
    }

    public void setClearButtonCaption(String clearButtonCaption) {
        this.clearButtonCaption = clearButtonCaption;
    }
}

