/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.format;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiBorder;
import org.teamapps.ux.component.format.Line;
import org.teamapps.ux.component.format.LineType;

public class Border {
    private final Line top;
    private final Line left;
    private final Line bottom;
    private final Line right;
    private float borderRadius;

    public Border(Color color, float thickness, float borderRadius) {
        this(new Line(color, LineType.SOLID, thickness));
        this.borderRadius = borderRadius;
    }

    public Border(Line line) {
        this.top = line;
        this.left = line;
        this.bottom = line;
        this.right = line;
    }

    public Border(Line top, Line left, Line bottom, Line right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Border(Line top, Line left, Line bottom, Line right, float borderRadius) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.borderRadius = borderRadius;
    }

    public Line getTop() {
        return this.top;
    }

    public Line getLeft() {
        return this.left;
    }

    public Line getBottom() {
        return this.bottom;
    }

    public Line getRight() {
        return this.right;
    }

    public float getBorderRadius() {
        return this.borderRadius;
    }

    public Border setBorderRadius(float borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    public UiBorder createUiBorder() {
        UiBorder uiBorder = new UiBorder();
        uiBorder.setTop(this.top != null ? this.top.createUiLine() : null);
        uiBorder.setLeft(this.left != null ? this.left.createUiLine() : null);
        uiBorder.setBottom(this.bottom != null ? this.bottom.createUiLine() : null);
        uiBorder.setRight(this.right != null ? this.right.createUiLine() : null);
        uiBorder.setBorderRadius(this.borderRadius);
        return uiBorder;
    }
}

