/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiGridLayout;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridPlacement;
import org.teamapps.ux.component.grid.layout.GridRow;

public class GridLayoutDefinition {
    private List<GridColumn> columns = new ArrayList<GridColumn>();
    private List<GridRow> rows = new ArrayList<GridRow>();
    private List<GridPlacement> placements = new ArrayList<GridPlacement>();
    private int gridGap = 7;
    private Spacing margin;
    private Spacing padding;
    private Border border;
    private Shadow shadow;
    private Color backgroundColor;

    public GridLayoutDefinition() {
    }

    public GridLayoutDefinition(List<GridColumn> columns, List<GridRow> rows, List<GridPlacement> placements) {
        this.columns.addAll(columns);
        this.rows.addAll(rows);
        this.placements.addAll(placements);
    }

    public GridLayoutDefinition addColumn(GridColumn column) {
        this.columns.add(column);
        return this;
    }

    public GridLayoutDefinition addRow(GridRow row) {
        this.rows.add(row);
        return this;
    }

    public GridLayoutDefinition addPlacement(GridPlacement placement) {
        this.placements.add(placement);
        return this;
    }

    public UiGridLayout createUiGridLayout() {
        UiGridLayout uiGridLayout = new UiGridLayout(this.columns.stream().map(c -> c.createUiGridColumn()).collect(Collectors.toList()), this.rows.stream().map(r -> r.createUiGridRow()).collect(Collectors.toList()), this.placements.stream().map(p -> p.createUiGridPlacement()).collect(Collectors.toList()));
        uiGridLayout.setGridGap(this.gridGap);
        uiGridLayout.setMargin(this.margin != null ? this.margin.createUiSpacing() : null);
        uiGridLayout.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        uiGridLayout.setBorder(this.border != null ? this.border.createUiBorder() : null);
        uiGridLayout.setShadow(this.shadow != null ? this.shadow.createUiShadow() : null);
        uiGridLayout.setBackgroundColor(this.backgroundColor != null ? UiUtil.createUiColor(this.backgroundColor) : null);
        return uiGridLayout;
    }

    public List<GridColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<GridColumn> columns) {
        this.columns = columns;
    }

    public List<GridRow> getRows() {
        return this.rows;
    }

    public void setRows(List<GridRow> rows) {
        this.rows = rows;
    }

    public List<GridPlacement> getPlacements() {
        return this.placements;
    }

    public void setPlacements(List<GridPlacement> placements) {
        this.placements = placements;
    }

    public int getGridGap() {
        return this.gridGap;
    }

    public void setGridGap(int gridGap) {
        this.gridGap = gridGap;
    }

    public Spacing getMargin() {
        return this.margin;
    }

    public void setMargin(Spacing margin) {
        this.margin = margin;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public void setPadding(Spacing padding) {
        this.padding = padding;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Shadow getShadow() {
        return this.shadow;
    }

    public void setShadow(Shadow shadow) {
        this.shadow = shadow;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

