/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.mobile;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMobileLayout;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.mobile.NavigationBar;
import org.teamapps.ux.component.toolbar.Toolbar;

public class MobileLayout
extends AbstractComponent
implements Container {
    protected Toolbar toolbar;
    protected Component content;
    protected NavigationBar navigationBar;

    @Override
    public UiComponent createUiComponent() {
        UiMobileLayout uiMobileLayout = new UiMobileLayout();
        this.mapAbstractUiComponentProperties((UiComponent)uiMobileLayout);
        if (this.content != null) {
            uiMobileLayout.setInitialView(this.content.createUiReference());
        }
        if (this.toolbar != null) {
            uiMobileLayout.setToolbar(this.toolbar.createUiReference());
        }
        uiMobileLayout.setNavigationBar(this.navigationBar != null ? this.navigationBar.createUiReference() : null);
        return uiMobileLayout;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public void preloadView(Component component) {
        component.render();
    }

    public void setContent(Component component) {
        this.setContent(component, null, 0);
    }

    public void setContent(Component component, PageTransition animation, int animationDuration) {
        this.content = component;
        component.setParent(this);
        this.queueCommandIfRendered(() -> new UiMobileLayout.ShowViewCommand(this.getId(), component.createUiReference(), animation != null ? animation.toUiPageTransition() : null, animationDuration));
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    public Component getContent() {
        return this.content;
    }

    public NavigationBar getNavigationBar() {
        return this.navigationBar;
    }

    public void setNavigationBar(NavigationBar navigationBar) {
        this.navigationBar = navigationBar;
        if (navigationBar != null) {
            navigationBar.setParent(this);
        }
        this.queueCommandIfRendered(() -> new UiMobileLayout.SetNavigationBarCommand(this.getId(), navigationBar != null ? navigationBar.createUiReference() : null));
    }

    @Override
    public boolean isChildVisible(Component child) {
        return this.isEffectivelyVisible() && (child == this.navigationBar || child == this.content || child == this.toolbar);
    }
}

