/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.progress;

import java.util.function.Consumer;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiProgressDisplay;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.task.ObservableProgress;
import org.teamapps.ux.task.ProgressChangeEventData;
import org.teamapps.ux.task.ProgressStatus;

public class ProgressDisplay
extends AbstractComponent {
    public final Event<Void> onClicked = new Event();
    public final Event<Void> onCancelButtonClicked = new Event();
    private Icon icon;
    private String taskName;
    private String statusMessage;
    private double progress;
    private ProgressStatus status = ProgressStatus.NOT_YET_STARTED;
    private boolean cancelable;
    private ObservableProgress observedProgress;
    private final Consumer<ProgressChangeEventData> observedProgressChangeListener = data -> {
        this.setStatus(data.getStatus());
        this.setStatusMessage(data.getStatusMessage());
        this.setProgress(data.getProgress());
        this.setCancelable(data.isCancelable());
        this.updateUi();
    };

    public ProgressDisplay() {
        this(null, null, null);
    }

    public ProgressDisplay(Icon icon, String taskName) {
        this(icon, taskName, null);
    }

    public ProgressDisplay(Icon icon, String taskName, ObservableProgress progress) {
        this.icon = icon;
        this.taskName = taskName;
        this.setObservedProgress(progress);
    }

    public UiProgressDisplay createUiComponent() {
        UiProgressDisplay ui = new UiProgressDisplay();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setIcon(this.getSessionContext().resolveIcon(this.icon));
        ui.setTaskName(this.taskName);
        ui.setStatusMessage(this.statusMessage);
        ui.setProgress(this.progress);
        ui.setStatus(this.status.toUiProgressStatus());
        ui.setCancelable(this.cancelable);
        return ui;
    }

    private void updateUi() {
        this.queueCommandIfRendered(() -> new UiProgressDisplay.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_PROGRESS_DISPLAY_CLICKED: {
                UiProgressDisplay.ClickedEvent clickedEvent = (UiProgressDisplay.ClickedEvent)event;
                this.onClicked.fire(null);
                break;
            }
            case UI_PROGRESS_DISPLAY_CANCEL_BUTTON_CLICKED: {
                UiProgressDisplay.CancelButtonClickedEvent cancelButtonClickedEvent = (UiProgressDisplay.CancelButtonClickedEvent)event;
                if (this.observedProgress != null) {
                    this.observedProgress.requestCancellation();
                }
                this.onCancelButtonClicked.fire(null);
                break;
            }
        }
    }

    public void setObservedProgress(ObservableProgress observableProgress) {
        if (this.observedProgress != null) {
            this.observedProgress.onChanged().removeListener(this.observedProgressChangeListener);
        }
        this.observedProgress = observableProgress;
        if (observableProgress != null) {
            observableProgress.onChanged().addListener(this.observedProgressChangeListener);
            this.statusMessage = observableProgress.getStatusMessage();
            this.progress = observableProgress.getProgress();
            this.status = observableProgress.getStatus();
            this.cancelable = observableProgress.isCancelable();
            this.updateUi();
        }
    }

    public ObservableProgress getObservedProgress() {
        return this.observedProgress;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.updateUi();
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
        this.updateUi();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.updateUi();
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
        this.updateUi();
    }

    public ProgressStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProgressStatus status) {
        this.status = status;
        this.updateUi();
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        this.updateUi();
    }
}

