/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.ux.component.workspacelayout.ViewGroupPanelState;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutViewGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;
import org.teamapps.ux.component.workspacelayout.definition.SplitPaneDefinition;
import org.teamapps.ux.component.workspacelayout.definition.ViewDefinition;

public class ViewGroupDefinition
extends LayoutItemDefinition {
    private final boolean persistent;
    private List<ViewDefinition> views;
    private ViewDefinition selectedView;
    private ViewGroupPanelState panelState;
    private SplitPaneDefinition parentSplitPane;

    public ViewGroupDefinition(String id, boolean persistent) {
        this(id, persistent, new ArrayList<ViewDefinition>(), null, ViewGroupPanelState.NORMAL);
    }

    public ViewGroupDefinition(String id, boolean persistent, List<ViewDefinition> views, ViewDefinition selectedView, ViewGroupPanelState panelState) {
        super(id);
        this.persistent = persistent;
        this.views = views;
        this.selectedView = selectedView;
        this.panelState = panelState;
    }

    @Override
    public List<ViewDefinition> getAllViews() {
        return this.views;
    }

    @Override
    public List<LayoutItemDefinition> getSelfAndAncestors() {
        return Collections.singletonList(this);
    }

    @Override
    public WorkSpaceLayoutItem createHeavyWeightItem(WorkSpaceLayout workSpaceLayout) {
        WorkSpaceLayoutViewGroup layoutViewGroup = new WorkSpaceLayoutViewGroup(this.getId(), this.persistent, workSpaceLayout);
        layoutViewGroup.setPanelState(this.panelState);
        return layoutViewGroup;
    }

    public void switchPosition(ViewGroupDefinition otherViewGroup) {
        SplitPaneDefinition previousParent = otherViewGroup.getParentSplitPane();
        if (this.getId().equals(this.parentSplitPane.getFirstChild().getId())) {
            this.parentSplitPane.setFirstChild(otherViewGroup);
        } else {
            this.parentSplitPane.setLastChild(otherViewGroup);
        }
        if (otherViewGroup.getId().equals(previousParent.getFirstChild().getId())) {
            previousParent.setFirstChild(this);
        } else {
            previousParent.setLastChild(this);
        }
    }

    public void addViewDefinition(ViewDefinition viewDefinition) {
        this.views.add(viewDefinition);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public List<ViewDefinition> getViews() {
        return this.views;
    }

    public void setViews(List<ViewDefinition> views) {
        this.views = views;
    }

    public ViewDefinition getSelectedView() {
        return this.selectedView;
    }

    public void setSelectedView(ViewDefinition selectedView) {
        this.selectedView = selectedView;
    }

    public ViewGroupPanelState getPanelState() {
        return this.panelState;
    }

    public void setPanelState(ViewGroupPanelState panelState) {
        this.panelState = panelState;
    }

    public SplitPaneDefinition getParentSplitPane() {
        return this.parentSplitPane;
    }

    protected void setParentSplitPane(SplitPaneDefinition parentSplitPane) {
        this.parentSplitPane = parentSplitPane;
    }
}

