/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import com.google.common.annotations.VisibleForTesting;
import org.teamapps.ux.resource.ClassPathResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.resource.ResourceProvider;

public class ClassPathResourceProvider
implements ResourceProvider {
    private final String basePackage;

    public ClassPathResourceProvider(String basePackage) {
        this.basePackage = ClassPathResourceProvider.normalizeClassPathResourcePath(basePackage);
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String sessionId) {
        return new ClassPathResource(this.getJavaResourceName(relativeResourcePath));
    }

    private String getJavaResourceName(String resource) {
        return this.basePackage + resource;
    }

    @VisibleForTesting
    static String normalizeClassPathResourcePath(String basePackage) {
        if (!((String)basePackage).contains("/") && ((String)basePackage).contains(".")) {
            basePackage = ((String)basePackage).replaceAll("\\.", "/");
        }
        if (!((String)basePackage).startsWith("/")) {
            basePackage = "/" + (String)basePackage;
        }
        if (((String)basePackage).endsWith("/")) {
            basePackage = ((String)basePackage).substring(0, ((String)basePackage).length() - 1);
        }
        return basePackage;
    }
}

