/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.ClientBackPressureInfo;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSessionActivityState;
import org.teamapps.util.MultiKeySequentialExecutor;
import org.teamapps.util.NamedThreadFactory;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.notification.Notification;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.popup.Popup;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.TemplateReference;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.i18n.MultiResourceBundle;
import org.teamapps.ux.i18n.UTF8Control;
import org.teamapps.ux.json.UxJacksonSerializationTemplate;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.ClientSessionResourceProvider;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.ExecutionDecorator;
import org.teamapps.ux.session.ExecutionDecoratorStack;
import org.teamapps.ux.session.SessionConfiguration;

public class SessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionContext.class);
    private static final MultiKeySequentialExecutor<SessionContext> sessionMultiKeyExecutor = new MultiKeySequentialExecutor(new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() / 2 + 1, Runtime.getRuntime().availableProcessors() * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("teamapps-session-executor", true)));
    private static final Function<Locale, ResourceBundle> DEFAULT_RESOURCE_BUNDLE_PROVIDER = locale -> ResourceBundle.getBundle("org.teamapps.ux.i18n.DefaultCaptions", locale, new UTF8Control());
    public final Event<UiSessionActivityState> onActivityStateChanged = new Event();
    public final Event<Void> onDestroyed = new Event();
    public final ExecutionDecoratorStack executionDecorators = new ExecutionDecoratorStack();
    private boolean active = true;
    private boolean destroyed = false;
    private final QualifiedUiSessionId sessionId;
    private final ClientInfo clientInfo;
    private HttpSession httpSession;
    private final UiCommandExecutor commandExecutor;
    private final UxServerContext serverContext;
    private final UxJacksonSerializationTemplate uxJacksonSerializationTemplate;
    private final HashMap<String, ClientObject> clientObjectsById = new HashMap();
    private IconTheme iconTheme;
    private ClientSessionResourceProvider sessionResourceProvider;
    private Function<Locale, ResourceBundle> customMessageBundleProvider = DEFAULT_RESOURCE_BUNDLE_PROVIDER;
    private ResourceBundle messagesBundle;
    private Map<String, Template> registeredTemplates = new ConcurrentHashMap<String, Template>();
    private SessionConfiguration sessionConfiguration = SessionConfiguration.createDefault();

    public SessionContext(QualifiedUiSessionId sessionId, ClientInfo clientInfo, HttpSession httpSession, UiCommandExecutor commandExecutor, UxServerContext serverContext, IconTheme iconTheme, ObjectMapper jacksonObjectMapper) {
        this.sessionId = sessionId;
        this.httpSession = httpSession;
        this.clientInfo = clientInfo;
        this.commandExecutor = commandExecutor;
        this.serverContext = serverContext;
        this.iconTheme = iconTheme;
        this.sessionResourceProvider = new ClientSessionResourceProvider(sessionId);
        this.uxJacksonSerializationTemplate = new UxJacksonSerializationTemplate(jacksonObjectMapper, this);
        this.updateMessageBundle();
    }

    public static SessionContext current() {
        return CurrentSessionContext.get();
    }

    public static SessionContext currentOrNull() {
        return CurrentSessionContext.getOrNull();
    }

    public void setCustomMessageBundleProvider(Function<Locale, ResourceBundle> provider) {
        this.customMessageBundleProvider = provider;
        this.updateMessageBundle();
    }

    private void updateMessageBundle() {
        if (this.customMessageBundleProvider != null) {
            ResourceBundle customResourceBundle = this.customMessageBundleProvider.apply(this.sessionConfiguration.getLanguageLocale());
            ResourceBundle defaultResourceBundle = DEFAULT_RESOURCE_BUNDLE_PROVIDER.apply(this.sessionConfiguration.getLanguageLocale());
            this.messagesBundle = new MultiResourceBundle(customResourceBundle, defaultResourceBundle);
        } else {
            this.messagesBundle = DEFAULT_RESOURCE_BUNDLE_PROVIDER.apply(this.sessionConfiguration.getLanguageLocale());
        }
    }

    public Locale getLocale() {
        return this.sessionConfiguration.getLanguageLocale();
    }

    public ResourceBundle getMessageBundle() {
        return this.messagesBundle;
    }

    public String getLocalized(String key, Object ... parameters) {
        String value = this.messagesBundle.getString(key);
        if (parameters != null) {
            return MessageFormat.format(value, parameters);
        }
        return value;
    }

    public boolean isActive() {
        return this.active;
    }

    public void handleActivityStateChangedInternal(boolean active) {
        this.active = active;
        this.onActivityStateChanged.fire(new UiSessionActivityState(active));
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.commandExecutor.closeSession(this.sessionId, UiSessionClosingReason.TERMINATED_BY_APPLICATION);
    }

    public void handleSessionDestroyedInternal() {
        this.destroyed = true;
        this.onDestroyed.fireIgnoringExceptions(null);
        sessionMultiKeyExecutor.closeForKey(this);
    }

    public Event<Void> onDestroyed() {
        return this.onDestroyed;
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command, Consumer<RESULT> resultCallback) {
        if (CurrentSessionContext.get() != this) {
            String errorMessage = "Trying to queue a command for foreign/null SessionContext (CurrentSessionContext.get() != this). Please use SessionContext.runWithContext(Runnable). NOTE: The command will not get queued!";
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Consumer<Object> wrappedCallback = resultCallback != null ? result -> this.runWithContext(() -> resultCallback.accept(result)) : null;
        this.uxJacksonSerializationTemplate.doWithUxJacksonSerializers(() -> this.commandExecutor.sendCommand(this.sessionId, new UiCommandWithResultCallback(command, wrappedCallback)));
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command) {
        this.queueCommand(command, null);
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Deprecated
    public void flushCommands() {
    }

    public ClientBackPressureInfo getClientBackPressureInfo() {
        return this.commandExecutor.getClientBackPressureInfo(this.sessionId);
    }

    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    public void setIconTheme(IconTheme theme) {
        this.iconTheme = theme;
    }

    public String createFileLink(File file) {
        return this.sessionResourceProvider.createFileLink(file);
    }

    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        return this.sessionResourceProvider.createResourceLink(resource, uniqueIdentifier);
    }

    public Resource getBinaryResource(int resourceId) {
        return this.sessionResourceProvider.getBinaryResource(resourceId);
    }

    public File getUploadedFileByUuid(String uuid) {
        return this.serverContext.getUploadedFileByUuid(uuid);
    }

    public TemplateReference registerTemplate(String id, Template template) {
        this.registeredTemplates.put(id, template);
        this.queueCommand((UiCommand)new UiRootPanel.RegisterTemplateCommand(id, template.createUiTemplate()));
        return new TemplateReference(template, id);
    }

    public void registerTemplates(Map<String, Template> templates) {
        this.registeredTemplates.putAll(templates);
        this.queueCommand((UiCommand)new UiRootPanel.RegisterTemplatesCommand(templates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Template)entry.getValue()).createUiTemplate()))));
    }

    public Template getTemplate(String id) {
        return this.registeredTemplates.get(id);
    }

    public CompletableFuture<Void> runWithContext(Runnable runnable) {
        return this.runWithContext(runnable, false);
    }

    public CompletableFuture<Void> runWithContext(Runnable runnable, boolean forceEnqueue) {
        if (CurrentSessionContext.getOrNull() == this && !forceEnqueue) {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
        return sessionMultiKeyExecutor.submit(this, () -> {
            CurrentSessionContext.set(this);
            try {
                this.executionDecorators.createWrappedRunnable(runnable).run();
            }
            finally {
                CurrentSessionContext.unset();
            }
            this.flushCommands();
        });
    }

    public void addExecutionDecorator(ExecutionDecorator decorator, boolean outer) {
        if (outer) {
            this.executionDecorators.addOuterDecorator(decorator);
        } else {
            this.executionDecorators.addInnerDecorator(decorator);
        }
    }

    public SessionConfiguration getConfiguration() {
        return this.sessionConfiguration;
    }

    public void setConfiguration(SessionConfiguration config) {
        this.sessionConfiguration = config;
        this.updateMessageBundle();
        this.queueCommand((UiCommand)new UiRootPanel.SetConfigCommand(config.createUiConfiguration()));
    }

    public void showPopupAtCurrentMousePosition(Popup popup) {
        this.queueCommand((UiCommand)new UiRootPanel.ShowPopupAtCurrentMousePositionCommand(popup.createUiReference()));
    }

    public void showPopup(Popup popup) {
        this.queueCommand((UiCommand)new UiRootPanel.ShowPopupCommand(popup.createUiReference()));
    }

    public Locale getLanguageLocale() {
        return this.getConfiguration().getLanguageLocale();
    }

    public ZoneId getTimeZone() {
        return this.getConfiguration().getTimeZone();
    }

    public String resolveIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        return this.sessionConfiguration.getIconPath() + "/-1/" + icon.getQualifiedIconId(this.getIconTheme());
    }

    public void registerClientObject(ClientObject clientObject) {
        this.clientObjectsById.put(clientObject.getId(), clientObject);
    }

    public void unregisterClientObject(ClientObject clientObject) {
        this.clientObjectsById.remove(clientObject.getId());
    }

    public ClientObject getClientObject(String clientObjectId) {
        return this.clientObjectsById.get(clientObjectId);
    }

    public String createResourceLink(Resource resource) {
        return this.createResourceLink(resource, null);
    }

    public void showWindow(Window window, int animationDuration) {
        window.show(animationDuration);
    }

    public void downloadFile(String fileUrl, String downloadFileName) {
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.DownloadFileCommand(fileUrl, downloadFileName)));
    }

    public void registerBackgroundImage(String id, String image, String blurredImage) {
        this.queueCommand((UiCommand)new UiRootPanel.RegisterBackgroundImageCommand(id, image, blurredImage));
    }

    public void setBackgroundImage(String id, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.SetBackgroundImageCommand(id, animationDuration));
    }

    public void setBackgroundColor(Color color, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.SetBackgroundColorCommand(UiUtil.createUiColor(color), animationDuration));
    }

    public void exitFullScreen() {
        this.queueCommand((UiCommand)new UiRootPanel.ExitFullScreenCommand());
    }

    public void addRootComponent(String containerElementId, RootPanel rootPanel) {
        this.queueCommand((UiCommand)new UiRootPanel.BuildRootPanelCommand(containerElementId, rootPanel.createUiReference()));
    }

    public void addClientToken(String token) {
        this.queueCommand((UiCommand)new UiRootPanel.AddClientTokenCommand(token));
    }

    public void removeClientToken(String token) {
        this.queueCommand((UiCommand)new UiRootPanel.RemoveClientTokenCommand(token));
    }

    public void clearClientTokens() {
        this.queueCommand((UiCommand)new UiRootPanel.ClearClientTokensCommand());
    }

    public void showNotification(Notification notification, NotificationPosition position, EntranceAnimation entranceAnimation, ExitAnimation exitAnimation) {
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.ShowNotificationCommand(notification.createUiReference(), position.toUiNotificationPosition(), entranceAnimation.toUiEntranceAnimation(), exitAnimation.toUiExitAnimation())));
    }

    public void showNotification(Notification notification, NotificationPosition position) {
        this.runWithContext(() -> this.showNotification(notification, position, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT));
    }

    public void showNotification(Icon icon, String caption) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndCaption(icon, caption);
            notification.setDismissible(true);
            notification.setShowProgressBar(false);
            notification.setDisplayTimeInMillis(5000);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void showNotification(Icon icon, String caption, String description) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
            notification.setDismissible(true);
            notification.setShowProgressBar(false);
            notification.setDisplayTimeInMillis(5000);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void showNotification(Icon icon, String caption, String description, boolean dismissable, int displayTimeInMillis, boolean showProgress) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
            notification.setDismissible(dismissable);
            notification.setDisplayTimeInMillis(displayTimeInMillis);
            notification.setShowProgressBar(showProgress);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }
}

