/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.Limit;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.data.value.filter.AllMatchingFilter;
import org.teamapps.data.value.filter.AndFilter;
import org.teamapps.data.value.filter.BooleanFilter;
import org.teamapps.data.value.filter.FilterType;
import org.teamapps.data.value.filter.FullTextFilter;
import org.teamapps.data.value.filter.IdValueFilter;
import org.teamapps.data.value.filter.NumericFilter;
import org.teamapps.data.value.filter.NumericRangeFilter;
import org.teamapps.data.value.filter.OrFilter;
import org.teamapps.data.value.filter.TextFilter;

public interface Filter {
    public FilterType getType();

    public String getProperty();

    default public boolean matches(DataRecord record) {
        return this.matches(record, true);
    }

    public boolean matches(DataRecord var1, boolean var2);

    default public String explain() {
        return this.explain(0);
    }

    public String explain(int var1);

    default public String createLevelIndentString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    default public Filter and(Filter filter) {
        if (filter == null) {
            return this;
        }
        return new AndFilter(this, filter);
    }

    default public Filter or(Filter filter) {
        if (filter == null) {
            return this;
        }
        return new OrFilter(this, filter);
    }

    default public Filter asOrFilter() {
        return new OrFilter(this);
    }

    public static Filter allMatchingFilter() {
        return new AllMatchingFilter();
    }

    public static Filter booleanFilter(String property, boolean value) {
        return new BooleanFilter(property, value);
    }

    public static Filter numericEqual(String property, double value) {
        return new NumericFilter(property, value, NumericFilter.Comparator.EQUAL);
    }

    public static Filter numericUnEqual(String property, double value) {
        return new NumericFilter(property, value, NumericFilter.Comparator.UNEQUAL);
    }

    public static Filter numericSmaller(String property, double value) {
        return new NumericFilter(property, value, NumericFilter.Comparator.SMALLER);
    }

    public static Filter numericSmallerOrEqual(String property, double value) {
        return new NumericFilter(property, value, NumericFilter.Comparator.SMALLER_OR_EQUAL);
    }

    public static Filter numericGreater(String property, double value) {
        return new NumericFilter(property, value, NumericFilter.Comparator.GREATER);
    }

    public static Filter numericGreaterOrEqual(String property, double value) {
        return new NumericFilter(property, value, NumericFilter.Comparator.GREATER_OR_EQUAL);
    }

    public static Filter numericRangeBetween(String property, double start, double end) {
        return new NumericRangeFilter(property, start, end, NumericRangeFilter.Comparator.BETWEEN);
    }

    public static Filter numericRangeBetweenInclusive(String property, double start, double end) {
        return new NumericRangeFilter(property, start, end, NumericRangeFilter.Comparator.BETWEEN_INCLUSIVE);
    }

    public static Filter numericRangeOutside(String property, double start, double end) {
        return new NumericRangeFilter(property, start, end, NumericRangeFilter.Comparator.OUTSIDE);
    }

    public static Filter numericRangeOutsideInclusive(String property, double start, double end) {
        return new NumericRangeFilter(property, start, end, NumericRangeFilter.Comparator.OUTSIDE_INCLUSIVE);
    }

    public static Filter idValueEqual(String property, Object value) {
        return new IdValueFilter(property, value, IdValueFilter.Comparator.EQUAL);
    }

    public static Filter idValueUnEqual(String property, Object value) {
        return new IdValueFilter(property, value, IdValueFilter.Comparator.UNEQUAL);
    }

    public static Filter idValueSmaller(String property, Object value) {
        return new IdValueFilter(property, value, IdValueFilter.Comparator.SMALLER);
    }

    public static Filter idValueSmallerOrEqual(String property, Object value) {
        return new IdValueFilter(property, value, IdValueFilter.Comparator.SMALLER_OR_EQUAL);
    }

    public static Filter idValueGreater(String property, Object value) {
        return new IdValueFilter(property, value, IdValueFilter.Comparator.GREATER);
    }

    public static Filter idValueGreaterOrEqual(String property, Object value) {
        return new IdValueFilter(property, value, IdValueFilter.Comparator.GREATER_OR_EQUAL);
    }

    public static Filter textEqual(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.EQUAL);
    }

    public static Filter textUnequal(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.UNEQUAL);
    }

    public static Filter textStartsWith(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.STARTS_WITH);
    }

    public static Filter textStartsNotWith(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.STARTS_NOT_WITH);
    }

    public static Filter textWildcard(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.WILDCARD);
    }

    public static Filter textUnequalWildcard(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.UNEQUAL_WILDCARD);
    }

    public static Filter textFuzzy(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.FUZZY);
    }

    public static Filter textUnequalFuzzy(String property, String value) {
        return new TextFilter(property, value, TextFilter.Comparator.UNEQUAL_FUZZY);
    }

    public static Filter rawFullTextFilter(String value) {
        return new FullTextFilter(value);
    }

    public static <T extends DataRecord> List<T> filterRecords(List<T> records, Filter filter) {
        return records.stream().filter(record -> filter.matches((DataRecord)record)).collect(Collectors.toList());
    }

    public static <T extends DataRecord> List<T> sortRecords(List<T> records, Sorting sorting) {
        if (sorting != null && sorting.getFieldName() != null) {
            String fieldName = sorting.getFieldName();
            Comparator stringComparator = Comparator.nullsFirst(String::compareToIgnoreCase);
            List sortedRecords = records.stream().sorted((o1, o2) -> stringComparator.compare(Filter.extractString(o1, fieldName), Filter.extractString(o2, fieldName))).collect(Collectors.toList());
            if (sorting.getSorting() == SortDirection.DESC) {
                Collections.reverse(sortedRecords);
            }
            return sortedRecords;
        }
        return records;
    }

    public static String extractString(DataRecord o, String fieldName) {
        if (o == null || o.getValue(fieldName) == null) {
            return null;
        }
        return o.getValue(fieldName).toString();
    }

    public static <T extends DataRecord> List<T> limitRecords(List<T> records, Limit limit) {
        if (limit != null) {
            return records.subList(limit.getStartIndex(), Math.min(records.size(), limit.getLength() + limit.getStartIndex()));
        }
        return records;
    }

    public static <T extends DataRecord> List<T> queryRecords(List<T> records, Filter query, Sorting sorting, Limit limit) {
        return Filter.limitRecords(Filter.sortRecords(Filter.filterRecords(records, query), sorting), limit);
    }
}

