/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.databinding;

import java.util.function.Consumer;

public class NonRecursiveEventListenerBuilder {
    private final ThreadLocal<Boolean> processing = new ThreadLocal();

    public <EVENT_DATA> Consumer<EVENT_DATA> create(Consumer<EVENT_DATA> handler) {
        return eventData -> {
            if (!this.isAlreadyProcessing()) {
                this.processing.set(true);
                try {
                    handler.accept(eventData);
                }
                finally {
                    this.processing.set(false);
                }
            }
        };
    }

    private boolean isAlreadyProcessing() {
        return this.processing.get() != null && this.processing.get() != false;
    }
}

