/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server;

import java.util.function.Function;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.session.SessionContext;

public class SessionResourceProvider
implements ResourceProvider {
    private final Function<QualifiedUiSessionId, SessionContext> sessionContexts;

    public SessionResourceProvider(Function<QualifiedUiSessionId, SessionContext> sessionContexts) {
        this.sessionContexts = sessionContexts;
    }

    private SessionContext getSessionContext(String resource, String httpSessionId) {
        if (resource == null) {
            return null;
        }
        String[] parts = resource.split("/");
        QualifiedUiSessionId qualifiedUiSessionId = new QualifiedUiSessionId(httpSessionId, parts[0]);
        return this.sessionContexts.apply(qualifiedUiSessionId);
    }

    private Resource getResource(String resource, String httpSessionId) {
        try {
            String[] parts;
            QualifiedUiSessionId qualifiedUiSessionId;
            SessionContext sessionContext;
            if (resource == null) {
                return null;
            }
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if ((sessionContext = this.sessionContexts.apply(qualifiedUiSessionId = new QualifiedUiSessionId(httpSessionId, (parts = resource.split("/"))[0]))) == null) {
                return null;
            }
            int id = Integer.parseInt(parts[1].substring(3));
            return sessionContext.getBinaryResource(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String httpSessionId) {
        return this.getResource(relativeResourcePath, httpSessionId);
    }
}

