/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import org.teamapps.dto.AbstractUiDateField;
import org.teamapps.dto.AbstractUiTimeField;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;

public abstract class AbstractTimeField<FIELD extends AbstractTimeField, VALUE>
extends AbstractField<VALUE>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private boolean showDropDownButton = true;
    private boolean showClearButton = false;
    private String timeFormat = null;

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    public void mapAbstractTimeFieldUiValues(AbstractUiTimeField uiTimeField) {
        this.mapAbstractFieldAttributesToUiField((UiField)uiTimeField);
        uiTimeField.setShowDropDownButton(this.isShowDropDownButton());
        uiTimeField.setTimeFormat(this.getTimeFormat());
        uiTimeField.setShowClearButton(this.isShowClearButton());
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetShowDropDownButtonCommand(this.getId(), showDropDownButton));
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetDateFormatCommand(this.getId(), timeFormat));
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetShowClearButtonCommand(this.getId(), showClearButton));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

