/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import java.util.Objects;
import org.teamapps.dto.UiVideoTrackConstraints;
import org.teamapps.ux.component.webrtc.VideoFacingMode;

public class VideoTrackConstraints {
    private String deviceId = null;
    private int width = 800;
    private int height = 600;
    private VideoFacingMode facingMode = VideoFacingMode.USER;
    private int frameRate = 20;

    public VideoTrackConstraints() {
    }

    public VideoTrackConstraints(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public VideoTrackConstraints(int width, int height, VideoFacingMode facingMode, int frameRate) {
        this.width = width;
        this.height = height;
        this.facingMode = facingMode;
        this.frameRate = frameRate;
    }

    public UiVideoTrackConstraints createUiVideoTrackConstraints() {
        UiVideoTrackConstraints ui = new UiVideoTrackConstraints();
        ui.setHeight(Integer.valueOf(this.height));
        ui.setWidth(Integer.valueOf(this.width));
        ui.setFacingMode(this.facingMode.toUiVideoFacingMode());
        ui.setFrameRate((double)this.frameRate);
        ui.setDeviceId(this.deviceId);
        return ui;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public VideoFacingMode getFacingMode() {
        return this.facingMode;
    }

    public void setFacingMode(VideoFacingMode facingMode) {
        this.facingMode = facingMode;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoTrackConstraints that = (VideoTrackConstraints)o;
        return this.width == that.width && this.height == that.height && this.frameRate == that.frameRate && Objects.equals(this.deviceId, that.deviceId) && this.facingMode == that.facingMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.width, this.height, this.facingMode, this.frameRate});
    }
}

