/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKeySequentialExecutor<K> {
    private static Logger LOGGER = LoggerFactory.getLogger(MultiKeySequentialExecutor.class);
    private Map<K, SequentialExecutor> sequentialExecutors = new ConcurrentHashMap<K, SequentialExecutor>();
    private ExecutorService pool;

    public MultiKeySequentialExecutor(int nThreads) {
        this.pool = Executors.newFixedThreadPool(nThreads);
    }

    public MultiKeySequentialExecutor(ExecutorService executorService) {
        this.pool = executorService;
    }

    public CompletableFuture<Void> submit(K key, Runnable task) {
        return this.sequentialExecutors.computeIfAbsent(key, k -> new SequentialExecutor()).submit(task);
    }

    public <V> CompletableFuture<V> submit(K key, Supplier<V> task) {
        return this.sequentialExecutors.computeIfAbsent(key, k -> new SequentialExecutor()).submit(task);
    }

    public void closeForKey(K key) {
        this.sequentialExecutors.compute(key, (k, sequentialExecutor) -> {
            if (sequentialExecutor != null) {
                ((SequentialExecutor)sequentialExecutor).close();
            }
            return null;
        });
    }

    public SequentialExecutor getExecutorForKey(K key) {
        return this.sequentialExecutors.get(key);
    }

    public class SequentialExecutor
    implements Executor {
        private CompletableFuture<?> lastFuture = CompletableFuture.completedFuture(null);
        private AtomicInteger queueSize = new AtomicInteger(0);
        private boolean closed = false;

        @Override
        public void execute(Runnable command) {
            this.submit(command);
        }

        public synchronized CompletableFuture<Void> submit(Runnable runnable) {
            return this.submit(() -> {
                runnable.run();
                return null;
            });
        }

        public synchronized <V> CompletableFuture<V> submit(Supplier<V> task) {
            if (this.closed) {
                LOGGER.debug("SequentialExecutor already closed.");
                return CompletableFuture.failedFuture(new SequentialExecutorClosedException());
            }
            int queueSize = this.queueSize.incrementAndGet();
            LOGGER.debug("Queue size: {}", (Object)queueSize);
            if (queueSize > 500) {
                LOGGER.warn("Queue is very long: {}", (Object)queueSize);
            }
            long submitTime = System.currentTimeMillis();
            CompletionStage returnedFuture = this.lastFuture.thenApplyAsync(o -> {
                long executionStartTime = System.currentTimeMillis();
                long delay = executionStartTime - submitTime;
                if (delay > 3000L) {
                    LOGGER.warn("Execution delay high: {}", (Object)delay);
                }
                Object result = task.get();
                long executionTime = System.currentTimeMillis() - executionStartTime;
                if (executionTime > 1000L) {
                    LOGGER.warn("Execution time long: {}", (Object)executionTime);
                }
                this.queueSize.decrementAndGet();
                return result;
            }, (Executor)MultiKeySequentialExecutor.this.pool);
            this.lastFuture = ((CompletableFuture)returnedFuture).exceptionally(throwable -> {
                LOGGER.error("Error while executing: ", throwable);
                return null;
            });
            return returnedFuture;
        }

        private synchronized void close() {
            this.closed = true;
        }
    }

    public static class SequentialExecutorClosedException
    extends RuntimeException {
    }
}

