/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.linkbutton;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiLinkButton;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.linkbutton.LinkTarget;

public class LinkButton
extends AbstractComponent {
    public final Event<Void> onClicked = new Event();
    private String text;
    private String url;
    private LinkTarget target = LinkTarget.BLANK;

    public LinkButton(String text) {
        this(text, null);
    }

    public LinkButton(String text, String url) {
        this.text = text;
        this.url = url;
    }

    public UiLinkButton createUiComponent() {
        UiLinkButton ui = new UiLinkButton();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setText(this.text);
        ui.setUrl(this.url);
        ui.setTarget(this.target.toUiLinkTarget());
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_LINK_BUTTON_CLICKED: {
                this.onClicked.fire();
            }
        }
    }

    private void update() {
        this.queueCommandIfRendered(() -> new UiLinkButton.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.update();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.update();
    }

    public LinkTarget getTarget() {
        return this.target;
    }

    public void setTarget(LinkTarget target) {
        this.target = target;
        this.update();
    }
}

