/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.gridtemplate;

import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiTemplateElement;
import org.teamapps.dto.UiBadgeElement;
import org.teamapps.dto.UiTextElement;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.format.FontStyle;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.template.gridtemplate.TextElement;

public class BadgeElement
extends TextElement {
    private Color borderColor;

    public BadgeElement(String dataKey) {
        super(dataKey);
    }

    public BadgeElement(String dataKey, int row, int column) {
        super(dataKey, row, column);
    }

    public BadgeElement(String dataKey, int row, int column, int rowSpan, int colSpan) {
        super(dataKey, row, column, rowSpan, colSpan);
    }

    public BadgeElement(String dataKey, int row, int column, int rowSpan, int colSpan, HorizontalElementAlignment horizontalAlignment, VerticalElementAlignment verticalAlignment) {
        super(dataKey, row, column, rowSpan, colSpan, horizontalAlignment, verticalAlignment);
    }

    @Override
    public BadgeElement setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    @Override
    public BadgeElement setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    @Override
    public BadgeElement setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
        return this;
    }

    @Override
    public BadgeElement setPadding(Spacing padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public BadgeElement setDataKey(String dataKey) {
        this.dataKey = dataKey;
        return this;
    }

    @Override
    public AbstractUiTemplateElement createUiTemplateElement() {
        UiBadgeElement uiBadgeElement = new UiBadgeElement(this.dataKey, this.row, this.column);
        this.mapAbstractTemplateElementAttributesToUiElement((AbstractUiTemplateElement)uiBadgeElement);
        this.mapTextElementAttributesToUiElement((UiTextElement)uiBadgeElement);
        uiBadgeElement.setBorderColor(this.borderColor != null ? UiUtil.createUiColor(this.borderColor) : null);
        return uiBadgeElement;
    }

    @Override
    public BadgeElement setRow(int row) {
        this.row = row;
        return this;
    }

    @Override
    public BadgeElement setColumn(int column) {
        this.column = column;
        return this;
    }

    @Override
    public BadgeElement setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    @Override
    public BadgeElement setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    public BadgeElement setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }
}

