/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.partitioning;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.partitioning.AbstractRawTimedDataModel;

public class StaticRawTimedDataModel
extends AbstractRawTimedDataModel {
    private Map<String, long[]> eventTimestampsByDataSeriesId = new HashMap<String, long[]>();
    private Interval staticDomainX;

    public void setEventTimestampsByDataSeriesId(Map<String, long[]> eventTimestampsByDataSeriesId) {
        this.eventTimestampsByDataSeriesId = new HashMap<String, long[]>(eventTimestampsByDataSeriesId);
        this.onDataChanged.fire(null);
    }

    public void setEventTimestampsForDataSeriesIds(String dataSeriesId, long[] eventTimestamps) {
        this.eventTimestampsByDataSeriesId.put(dataSeriesId, eventTimestamps);
        this.onDataChanged.fire(null);
    }

    @Override
    protected long[] getRawEventTimes(String dataSeriesId, Interval neededIntervalX) {
        return this.eventTimestampsByDataSeriesId.get(dataSeriesId);
    }

    @Override
    public Interval getDomainX(Collection<String> dataSeriesId) {
        if (this.staticDomainX != null) {
            return this.staticDomainX;
        }
        long min = this.eventTimestampsByDataSeriesId.entrySet().stream().filter(e -> dataSeriesId.contains(e.getKey())).flatMapToLong(e -> Arrays.stream((long[])e.getValue())).min().orElse(0L);
        long max = this.eventTimestampsByDataSeriesId.entrySet().stream().filter(e -> dataSeriesId.contains(e.getKey())).flatMapToLong(e -> Arrays.stream((long[])e.getValue())).max().orElse(1L);
        return new Interval(min, max);
    }

    public void setStaticDomainX(Interval staticDomainX) {
        this.staticDomainX = staticDomainX;
    }
}

