/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.validation;

import org.teamapps.ux.component.field.FieldMessage;

public class ValidationMessage {
    private final String propertyName;
    private final FieldMessage fieldMessage;

    public static ValidationMessage info(String propertyName, String message) {
        return new ValidationMessage(propertyName, FieldMessage.Severity.INFO, message);
    }

    public static ValidationMessage warning(String propertyName, String message) {
        return new ValidationMessage(propertyName, FieldMessage.Severity.WARNING, message);
    }

    public static ValidationMessage error(String propertyName, String message) {
        return new ValidationMessage(propertyName, FieldMessage.Severity.ERROR, message);
    }

    public static ValidationMessage success(String propertyName, String message) {
        return new ValidationMessage(propertyName, FieldMessage.Severity.SUCCESS, message);
    }

    public ValidationMessage(String propertyName, FieldMessage.Severity severity, String message) {
        this.propertyName = propertyName;
        this.fieldMessage = new FieldMessage(severity, message);
    }

    public ValidationMessage(String propertyName, FieldMessage.Position position, FieldMessage.Visibility visibility, FieldMessage.Severity severity, String message) {
        this.propertyName = propertyName;
        this.fieldMessage = new FieldMessage(position, visibility, severity, message);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public FieldMessage getFieldMessage() {
        return this.fieldMessage;
    }
}

