/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiBaseTreeGraphNode;
import org.teamapps.dto.UiClientRecord;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiTreeGraph;
import org.teamapps.dto.UiTreeGraphNode;
import org.teamapps.event.Event;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.charting.tree.BaseTreeGraphNode;
import org.teamapps.ux.component.charting.tree.NodeExpandedOrCollapsedEvent;
import org.teamapps.ux.component.charting.tree.SideListExpandedOrCollapsedEvent;
import org.teamapps.ux.component.charting.tree.TreeGraphNode;
import org.teamapps.ux.component.template.Template;

public class TreeGraph<RECORD>
extends AbstractComponent {
    public final Event<TreeGraphNode<RECORD>> onNodeClicked = new Event();
    public final Event<NodeExpandedOrCollapsedEvent<RECORD>> onNodeExpandedOrCollapsed = new Event();
    public final Event<NodeExpandedOrCollapsedEvent<RECORD>> onParentExpandedOrCollapsed = new Event();
    public final Event<SideListExpandedOrCollapsedEvent<RECORD>> onSideListExpandedOrCollapsed = new Event();
    private float zoomFactor;
    private boolean compact = false;
    private int verticalLayerGap = 36;
    private int horizontalSiblingGap = 20;
    private int horizontalNonSignlingGap = 36;
    private int sideListIndent = 20;
    private int sideListVerticalGap = 20;
    private LinkedHashMap<String, TreeGraphNode<RECORD>> nodesById = new LinkedHashMap();
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();

    public UiTreeGraph createUiComponent() {
        UiTreeGraph ui = new UiTreeGraph();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setNodes(this.createUiNodes(this.nodesById.values()));
        ui.setZoomFactor(this.zoomFactor);
        ui.setCompact(this.compact);
        ui.setVerticalLayerGap(this.verticalLayerGap);
        ui.setSideListIndent(this.sideListIndent);
        ui.setSideListVerticalGap(this.sideListVerticalGap);
        ui.setHorizontalSiblingGap(this.horizontalSiblingGap);
        ui.setHorizontalNonSignlingGap(this.horizontalNonSignlingGap);
        return ui;
    }

    private List<UiTreeGraphNode> createUiNodes(Collection<TreeGraphNode<RECORD>> nodes) {
        return nodes.stream().map(this::createUiNode).collect(Collectors.toList());
    }

    private UiTreeGraphNode createUiNode(TreeGraphNode<RECORD> node) {
        UiTreeGraphNode uiNode = new UiTreeGraphNode(node.getId(), node.getWidth(), node.getHeight());
        this.mapBaseTreeGraphNodeAttributes(node, (UiBaseTreeGraphNode)uiNode);
        uiNode.setParentId(node.getParent() != null ? node.getParent().getId() : null);
        uiNode.setParentExpandable(node.isParentExpandable());
        uiNode.setParentExpanded(node.isParentExpanded());
        uiNode.setExpanded(node.isExpanded());
        uiNode.setHasLazyChildren(node.isHasLazyChildren());
        uiNode.setSideListNodes(node.getSideListNodes() != null ? node.getSideListNodes().stream().map(this::createBaseUiNode).collect(Collectors.toList()) : null);
        uiNode.setSideListExpanded(node.isSideListExpanded());
        return uiNode;
    }

    private UiBaseTreeGraphNode createBaseUiNode(BaseTreeGraphNode<RECORD> node) {
        UiBaseTreeGraphNode uiNode = new UiBaseTreeGraphNode(node.getId(), node.getWidth(), node.getHeight());
        this.mapBaseTreeGraphNodeAttributes(node, uiNode);
        return uiNode;
    }

    private void mapBaseTreeGraphNodeAttributes(BaseTreeGraphNode<RECORD> node, UiBaseTreeGraphNode uiNode) {
        uiNode.setBackgroundColor(node.getBackgroundColor() != null ? UiUtil.createUiColor(node.getBackgroundColor()) : null);
        uiNode.setBorderColor(node.getBorderColor() != null ? UiUtil.createUiColor(node.getBorderColor()) : null);
        uiNode.setBorderWidth(node.getBorderWidth());
        uiNode.setBorderRadius(node.getBorderRadius());
        uiNode.setImage(node.getImage() != null ? node.getImage().createUiTreeGraphNodeImage() : null);
        uiNode.setIcon(node.getIcon() != null ? node.getIcon().createUiTreeGraphNodeIcon() : null);
        uiNode.setTemplate(node.getTemplate() != null ? node.getTemplate().createUiTemplate() : null);
        uiNode.setRecord(node.getRecord() != null ? this.createUiRecord(node.getRecord(), node.getTemplate()) : null);
        uiNode.setConnectorLineColor(node.getConnectorLineColor() != null ? UiUtil.createUiColor(node.getConnectorLineColor()) : null);
        uiNode.setConnectorLineWidth(node.getConnectorLineWidth());
        uiNode.setDashArray(node.getDashArray());
    }

    private UiClientRecord createUiRecord(RECORD record, Template template) {
        UiClientRecord uiClientRecord = new UiClientRecord();
        uiClientRecord.setValues(this.propertyExtractor.getValues(record, template.getDataKeys()));
        return uiClientRecord;
    }

    public void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.queueCommandIfRendered(() -> new UiTreeGraph.SetZoomFactorCommand(this.getId(), zoomFactor));
    }

    public void setNodes(List<TreeGraphNode<RECORD>> nodes) {
        this.nodesById.clear();
        nodes.forEach(n -> this.nodesById.put(n.getId(), (TreeGraphNode<RECORD>)n));
        this.queueCommandIfRendered(() -> new UiTreeGraph.SetNodesCommand(this.getId(), this.createUiNodes(nodes)));
    }

    public void addNode(TreeGraphNode<RECORD> node) {
        this.nodesById.put(node.getId(), node);
        this.queueCommandIfRendered(() -> new UiTreeGraph.AddNodeCommand(this.getId(), this.createUiNode(node)));
    }

    public void addNodes(List<TreeGraphNode<RECORD>> nodes) {
        nodes.forEach(n -> this.nodesById.put(n.getId(), (TreeGraphNode<RECORD>)n));
        this.update();
    }

    public void removeNode(TreeGraphNode<RECORD> node) {
        this.nodesById.remove(node.getId());
        this.queueCommandIfRendered(() -> new UiTreeGraph.RemoveNodeCommand(this.getId(), node.getId()));
    }

    public void updateNode(TreeGraphNode<RECORD> node) {
        this.nodesById.put(node.getId(), node);
        this.queueCommandIfRendered(() -> new UiTreeGraph.UpdateNodeCommand(this.getId(), this.createUiNode(node)));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TREE_GRAPH_NODE_CLICKED: {
                UiTreeGraph.NodeClickedEvent e = (UiTreeGraph.NodeClickedEvent)event;
                TreeGraphNode<RECORD> node = this.nodesById.get(e.getNodeId());
                if (node == null) break;
                this.onNodeClicked.fire(node);
                break;
            }
            case UI_TREE_GRAPH_NODE_EXPANDED_OR_COLLAPSED: {
                UiTreeGraph.NodeExpandedOrCollapsedEvent e = (UiTreeGraph.NodeExpandedOrCollapsedEvent)event;
                TreeGraphNode<RECORD> node = this.nodesById.get(e.getNodeId());
                if (node == null) break;
                node.setExpanded(e.getExpanded());
                this.onNodeExpandedOrCollapsed.fire(new NodeExpandedOrCollapsedEvent<RECORD>(node, e.getExpanded(), e.getLazyLoad()));
                break;
            }
            case UI_TREE_GRAPH_PARENT_EXPANDED_OR_COLLAPSED: {
                UiTreeGraph.ParentExpandedOrCollapsedEvent e = (UiTreeGraph.ParentExpandedOrCollapsedEvent)event;
                TreeGraphNode<RECORD> node = this.nodesById.get(e.getNodeId());
                if (node == null) break;
                node.setParentExpanded(e.getExpanded());
                this.onParentExpandedOrCollapsed.fire(new NodeExpandedOrCollapsedEvent<RECORD>(node, e.getExpanded(), e.getLazyLoad()));
                break;
            }
            case UI_TREE_GRAPH_SIDE_LIST_EXPANDED_OR_COLLAPSED: {
                UiTreeGraph.SideListExpandedOrCollapsedEvent e = (UiTreeGraph.SideListExpandedOrCollapsedEvent)event;
                TreeGraphNode<RECORD> node = this.nodesById.get(e.getNodeId());
                if (node == null) break;
                node.setSideListExpanded(e.getExpanded());
                this.onSideListExpandedOrCollapsed.fire(new SideListExpandedOrCollapsedEvent<RECORD>(node, e.getExpanded()));
                break;
            }
        }
    }

    public boolean isCompact() {
        return this.compact;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
        this.update();
    }

    private void update() {
        this.queueCommandIfRendered(() -> new UiTreeGraph.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public void moveToRootNode() {
        this.queueCommandIfRendered(() -> new UiTreeGraph.MoveToRootNodeCommand(this.getId()));
    }

    public void moveToNode(TreeGraphNode<RECORD> node) {
        this.queueCommandIfRendered(() -> new UiTreeGraph.MoveToNodeCommand(this.getId(), node.getId()));
    }

    private Collection<TreeGraphNode<RECORD>> getAllDescendants(TreeGraphNode<RECORD> node, boolean includeSelf) {
        HashSet descendants = new HashSet();
        descendants.add(node);
        HashSet nonDescendants = new HashSet(this.getAncestors(node, false));
        List<TreeGraphNode<Object>> untaggedNodes = new ArrayList<TreeGraphNode<RECORD>>(this.nodesById.values());
        untaggedNodes.remove(node);
        boolean[] descendantsChanged = new boolean[1];
        boolean[] nonDescendantsChanged = new boolean[1];
        do {
            descendantsChanged[0] = false;
            nonDescendantsChanged[0] = false;
            untaggedNodes = untaggedNodes.stream().filter(n -> {
                if (descendants.contains(n.getParent())) {
                    descendants.add((TreeGraphNode)n);
                    descendantsChanged[0] = true;
                    return false;
                }
                if (nonDescendants.contains(n.getParent())) {
                    nonDescendants.add((TreeGraphNode)n);
                    nonDescendantsChanged[0] = true;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
        } while (descendantsChanged[0] && nonDescendantsChanged[0]);
        descendants.addAll(untaggedNodes);
        if (!includeSelf) {
            descendants.remove(node);
        }
        return descendants;
    }

    private List<TreeGraphNode<RECORD>> getAncestors(TreeGraphNode<RECORD> node, boolean includeSelf) {
        ArrayList<TreeGraphNode<RECORD>> ancestors = new ArrayList<TreeGraphNode<RECORD>>();
        if (includeSelf) {
            ancestors.add(node);
        }
        while (node.getParent() != null) {
            node = node.getParent();
            ancestors.add(node);
        }
        return ancestors;
    }

    public int getVerticalLayerGap() {
        return this.verticalLayerGap;
    }

    public void setVerticalLayerGap(int verticalLayerGap) {
        this.verticalLayerGap = verticalLayerGap;
        this.update();
    }

    public int getSideListIndent() {
        return this.sideListIndent;
    }

    public void setSideListIndent(int sideListIndent) {
        this.sideListIndent = sideListIndent;
        this.update();
    }

    public int getSideListVerticalGap() {
        return this.sideListVerticalGap;
    }

    public void setSideListVerticalGap(int sideListVerticalGap) {
        this.sideListVerticalGap = sideListVerticalGap;
        this.update();
    }

    public int getHorizontalSiblingGap() {
        return this.horizontalSiblingGap;
    }

    public void setHorizontalSiblingGap(int horizontalSiblingGap) {
        this.horizontalSiblingGap = horizontalSiblingGap;
        this.update();
    }

    public int getHorizontalNonSignlingGap() {
        return this.horizontalNonSignlingGap;
    }

    public void setHorizontalNonSignlingGap(int horizontalNonSignlingGap) {
        this.horizontalNonSignlingGap = horizontalNonSignlingGap;
        this.update();
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }
}

