/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import org.teamapps.dto.AbstractUiDateTimeField;
import org.teamapps.dto.UiField;
import org.teamapps.ux.component.field.AbstractField;

public abstract class AbstractDateTimeField<FIELD extends AbstractDateTimeField<FIELD, VALUE>, VALUE>
extends AbstractField<VALUE> {
    private boolean showDropDownButton = true;
    private boolean favorPastDates = false;
    private String dateFormat = null;
    private String timeFormat = null;

    protected void mapAbstractDateTimeFieldUiValues(AbstractUiDateTimeField uiField) {
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setShowDropDownButton(this.showDropDownButton);
        uiField.setFavorPastDates(this.favorPastDates);
        uiField.setDateFormat(this.dateFormat);
        uiField.setTimeFormat(this.timeFormat);
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetShowDropDownButtonCommand(this.getId(), showDropDownButton));
    }

    public boolean isFavorPastDates() {
        return this.favorPastDates;
    }

    public void setFavorPastDates(boolean favorPastDates) {
        this.favorPastDates = favorPastDates;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetFavorPastDatesCommand(this.getId(), favorPastDates));
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetDateFormatCommand(this.getId(), dateFormat));
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetTimeFormatCommand(this.getId(), timeFormat));
    }
}

