/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form.layoutpolicy;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiFormSectionFloatingFieldsPlacement;
import org.teamapps.dto.UiFormSectionPlacement;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionFloatingField;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionPlacement;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;

public class FormSectionFloatingFieldsPlacement
implements FormSectionPlacement {
    private List<FormSectionFloatingField> floatingFields = new ArrayList<FormSectionFloatingField>();
    private boolean wrap;
    private int horizontalSpacing = 5;
    private int verticalSpacing = 3;
    private int row;
    private int column;
    private int rowSpan;
    private int colSpan;
    private int minWidth;
    private int maxWidth;
    private VerticalElementAlignment verticalAlignment = VerticalElementAlignment.CENTER;
    private HorizontalElementAlignment horizontalAlignment = HorizontalElementAlignment.LEFT;

    public FormSectionFloatingFieldsPlacement(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public FormSectionFloatingFieldsPlacement(int row, int column, List<FormSectionFloatingField> floatingFields) {
        this.row = row;
        this.column = column;
        this.floatingFields = floatingFields;
    }

    public FormSectionFloatingFieldsPlacement(List<FormSectionFloatingField> floatingFields) {
        this.floatingFields = floatingFields;
    }

    public List<FormSectionFloatingField> getFloatingFields() {
        return this.floatingFields;
    }

    public void addFloatingField(FormSectionFloatingField floatingField) {
        this.floatingFields.add(floatingField);
    }

    public void setFloatingFields(List<FormSectionFloatingField> floatingFields) {
        this.floatingFields = floatingFields;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    @Override
    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public VerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public HorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public UiFormSectionPlacement createUiFormSectionPlacement() {
        List uiFloatingFields = this.floatingFields.stream().map(floatingField -> floatingField.createUiFormSectionFloatingField()).collect(Collectors.toList());
        UiFormSectionFloatingFieldsPlacement placement = new UiFormSectionFloatingFieldsPlacement(uiFloatingFields).setRow(this.row).setColumn(this.column).setWrap(this.wrap).setVerticalSpacing(this.verticalSpacing).setHorizontalSpacing(this.horizontalSpacing).setRowSpan(this.rowSpan).setColSpan(this.colSpan).setMinWidth(this.minWidth).setMaxWidth(this.maxWidth).setVerticalAlignment(this.verticalAlignment.toUiVerticalElementAlignment()).setHorizontalAlignment(this.horizontalAlignment.toUiHorizontalElementAlignment());
        return placement;
    }
}

