/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.AbstractUiLineChartDataDisplay;
import org.teamapps.dto.UiLineChartDataDisplayGroup;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.LineChartDataDisplayChangeListener;

public class LineChartDataDisplayGroup
extends AbstractLineChartDataDisplay {
    private LineChartDataDisplayChangeListener changeListener;
    private final List<AbstractLineChartDataDisplay> dataDisplays = new ArrayList<AbstractLineChartDataDisplay>();

    public LineChartDataDisplayGroup() {
    }

    public LineChartDataDisplayGroup(AbstractLineChartDataDisplay ... dataDisplays) {
        this(Arrays.asList(dataDisplays));
    }

    public LineChartDataDisplayGroup(List<AbstractLineChartDataDisplay> dataDisplays) {
        this.dataDisplays.addAll(dataDisplays);
        dataDisplays.forEach(dd -> {
            if (this.changeListener != null) {
                this.changeListener.handleChange(this);
            }
        });
    }

    @Override
    public AbstractUiLineChartDataDisplay createUiFormat() {
        UiLineChartDataDisplayGroup ui = new UiLineChartDataDisplayGroup();
        this.mapAbstractLineChartDataDisplayProperties((AbstractUiLineChartDataDisplay)ui);
        ui.setDataDisplays(this.dataDisplays.stream().map(AbstractLineChartDataDisplay::createUiFormat).collect(Collectors.toList()));
        return ui;
    }

    @Override
    public List<String> getDataSeriesIds() {
        return this.dataDisplays.stream().flatMap(dd -> dd.getDataSeriesIds().stream()).collect(Collectors.toList());
    }

    @Override
    public void setChangeListener(LineChartDataDisplayChangeListener listener) {
        this.changeListener = listener;
    }

    public void addDataDisplay(AbstractLineChartDataDisplay dataDisplay) {
        this.dataDisplays.add(dataDisplay);
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
    }

    public List<AbstractLineChartDataDisplay> getDataDisplays() {
        return this.dataDisplays;
    }
}

