/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.teamapps.ux.model.AbstractTreeModel;

public class ListTreeModel<RECORD>
extends AbstractTreeModel<RECORD> {
    private List<RECORD> records = new ArrayList<RECORD>();
    private BiPredicate<RECORD, String> searchPredicate = (record, queryString) -> record.toString() != null && record.toString().toLowerCase().contains(queryString.toLowerCase());

    public ListTreeModel(List<RECORD> records) {
        this(records, null);
    }

    public ListTreeModel(List<RECORD> records, BiPredicate<RECORD, String> searchPredicate) {
        this.records.addAll(records);
        if (searchPredicate != null) {
            this.searchPredicate = searchPredicate;
        }
    }

    @Override
    public List<RECORD> getRecords(String query) {
        if (query == null || query.isEmpty()) {
            return this.records;
        }
        return this.records.stream().filter(r -> this.searchPredicate.test(r, query)).collect(Collectors.toList());
    }

    public List<RECORD> getRecords() {
        return this.records;
    }

    public void setRecords(List<RECORD> records) {
        this.records.clear();
        this.records.addAll(records);
        this.onAllNodesChanged.fire();
    }

    public BiPredicate<RECORD, String> getSearchPredicate() {
        return this.searchPredicate;
    }

    public void setSearchPredicate(BiPredicate<RECORD, String> searchPredicate) {
        this.searchPredicate = searchPredicate;
    }
}

