/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.value.filter;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.data.value.DataRecord;
import org.teamapps.data.value.filter.Filter;
import org.teamapps.data.value.filter.FilterType;

public class OrFilter
implements Filter {
    private List<Filter> filters = new ArrayList<Filter>();

    public OrFilter() {
    }

    public OrFilter(Filter filter) {
        this.filters.add(filter);
    }

    public OrFilter(Filter filterA, Filter filterB) {
        this.filters.add(filterA);
        this.filters.add(filterB);
    }

    @Override
    public FilterType getType() {
        return FilterType.OR;
    }

    @Override
    public boolean matches(DataRecord record, boolean treatNullAsDefaultValue) {
        for (Filter filter : this.filters) {
            if (!filter.matches(record, treatNullAsDefaultValue)) continue;
            return true;
        }
        return this.filters.isEmpty();
    }

    @Override
    public String explain(int filterLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createLevelIndentString(filterLevel));
        sb.append("OR(").append("\n");
        for (Filter filter : this.filters) {
            sb.append(filter.explain(filterLevel + 1));
        }
        sb.append(this.createLevelIndentString(filterLevel));
        sb.append(")").append("\n");
        return sb.toString();
    }

    @Override
    public String getProperty() {
        return null;
    }

    @Override
    public Filter or(Filter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }
}

