/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.teamapps.ux.application.ApplicationChangeHandler;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.ResponsiveApplicationToolbar;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.perspective.PerspectiveChangeHandler;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class ResponsiveApplicationImpl
implements ResponsiveApplication {
    private final ApplicationAssembler assembler;
    private List<View> applicationViews = new ArrayList<View>();
    private List<Perspective> perspectives = new ArrayList<Perspective>();
    private Perspective activePerspective;
    private List<View> activeViews;
    private List<ToolbarButtonGroup> workspaceToolbarButtonGroups = new ArrayList<ToolbarButtonGroup>();
    private List<ApplicationChangeHandler> changeHandlers = new ArrayList<ApplicationChangeHandler>();
    private ResponsiveApplicationToolbar responsiveApplicationToolbar = new ResponsiveApplicationToolbar();

    public ResponsiveApplicationImpl(ApplicationAssembler assembler) {
        this.assembler = assembler;
        this.assembler.setWorkSpaceToolbar(this.responsiveApplicationToolbar);
        this.addApplicationChangeHandler(assembler);
        this.addApplicationChangeHandler(this.responsiveApplicationToolbar);
    }

    @Override
    public void addApplicationChangeHandler(ApplicationChangeHandler changeHandler) {
        this.changeHandlers.remove(changeHandler);
        this.changeHandlers.add(changeHandler);
    }

    @Override
    public void removeApplicationChangeHandler(ApplicationChangeHandler changeHandler) {
        this.changeHandlers.remove(changeHandler);
    }

    @Override
    public void addApplicationView(View view) {
        this.applicationViews.add(view);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationViewAdded(this, view));
    }

    @Override
    public void removeApplicationView(View view) {
        this.applicationViews.remove(view);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationViewRemoved(this, view));
    }

    @Override
    public List<View> getApplicationViews() {
        return this.applicationViews;
    }

    @Override
    public List<Perspective> getPerspectives() {
        return this.perspectives;
    }

    @Override
    public void addPerspective(Perspective perspective) {
        final ResponsiveApplicationImpl application = this;
        this.perspectives.add(perspective);
        perspective.addPerspectiveChangeHandler(new PerspectiveChangeHandler(){

            @Override
            public void handleLayoutChange(Perspective perspective, LayoutItemDefinition layoutItemDefinition) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleLayoutChange(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, layoutItemDefinition));
            }

            @Override
            public void handleViewAdded(Perspective perspective, View view) {
                if (ResponsiveApplicationImpl.this.isActivePerspective(perspective)) {
                    ResponsiveApplicationImpl.this.checkViewChange(view, true);
                }
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewAdded(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view));
            }

            @Override
            public void handleViewRemoved(Perspective perspective, View view) {
                if (ResponsiveApplicationImpl.this.isActivePerspective(perspective)) {
                    ResponsiveApplicationImpl.this.checkViewChange(view, false);
                }
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewRemoved(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view));
            }

            @Override
            public void handlePerspectiveToolbarButtonGroupAdded(Perspective perspective, ToolbarButtonGroup buttonGroup) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveToolbarButtonGroupAdded(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, buttonGroup));
            }

            @Override
            public void handlePerspectiveToolbarButtonGroupRemoved(Perspective perspective, ToolbarButtonGroup buttonGroup) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveToolbarButtonGroupRemoved(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, buttonGroup));
            }

            @Override
            public void handleViewVisibilityChange(Perspective perspective, View view, boolean visible) {
                if (ResponsiveApplicationImpl.this.isActivePerspective(perspective)) {
                    ResponsiveApplicationImpl.this.checkViewChange(view, visible);
                }
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewVisibilityChange(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view, visible));
            }

            @Override
            public void handleViewFocusRequest(Perspective perspective, View view, boolean ensureVisible) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewFocusRequest(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view, ensureVisible));
            }

            @Override
            public void handleViewSizeChange(Perspective perspective, View view, ViewSize viewSize) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewSizeChange(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view, viewSize));
            }

            @Override
            public void handleViewLayoutPositionChange(Perspective perspective, View view, String position) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewLayoutPositionChange(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view, position));
            }

            @Override
            public void handleViewWorkspaceToolbarButtonGroupAdded(Perspective perspective, View view, ToolbarButtonGroup buttonGroup) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewWorkspaceToolbarButtonGroupAdded(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view, buttonGroup));
            }

            @Override
            public void handleViewWorkspaceToolbarButtonGroupRemoved(Perspective perspective, View view, ToolbarButtonGroup buttonGroup) {
                ResponsiveApplicationImpl.this.changeHandlers.forEach(changeHandler -> changeHandler.handleViewWorkspaceToolbarButtonGroupRemoved(application, ResponsiveApplicationImpl.this.isActivePerspective(perspective), perspective, view, buttonGroup));
            }
        });
    }

    private void checkViewChange(View view, boolean show) {
        if (this.activeViews != null) {
            if (show) {
                this.activeViews.add(view);
            } else {
                this.activeViews.remove(view);
            }
        }
    }

    private boolean isActivePerspective(Perspective perspective) {
        return this.activePerspective != null && this.activePerspective.equals(perspective);
    }

    @Override
    public void showPerspective(Perspective perspective) {
        List<View> previousViews = this.activeViews;
        this.activeViews = perspective.getVisibleAndLayoutReferencedViews();
        ArrayList<View> removedViews = new ArrayList<View>();
        ArrayList<View> addedViews = new ArrayList<View>();
        if (previousViews != null) {
            HashSet<View> commonViews = new HashSet<View>(this.activeViews);
            commonViews.retainAll(previousViews);
            addedViews.addAll(this.activeViews);
            addedViews.removeAll(commonViews);
            removedViews.addAll(previousViews);
            removedViews.removeAll(commonViews);
        } else {
            addedViews.addAll(this.activeViews);
        }
        Perspective previousPerspective = this.activePerspective;
        this.activePerspective = perspective;
        this.changeHandlers.forEach(changeHandler -> changeHandler.handlePerspectiveChange(this, perspective, previousPerspective, this.activeViews, addedViews, removedViews));
    }

    @Override
    public List<View> getActiveViews() {
        return this.activeViews;
    }

    @Override
    public Perspective getActivePerspective() {
        return this.activePerspective;
    }

    @Override
    public void addApplicationButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.add(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationToolbarButtonGroupAdded(this, buttonGroup));
    }

    @Override
    public void removeApplicationButtonGroup(ToolbarButtonGroup buttonGroup) {
        this.workspaceToolbarButtonGroups.remove(buttonGroup);
        this.changeHandlers.forEach(changeHandler -> changeHandler.handleApplicationToolbarButtonGroupRemoved(this, buttonGroup));
    }

    @Override
    public List<ToolbarButtonGroup> getWorkspaceButtonGroups() {
        return this.workspaceToolbarButtonGroups;
    }

    @Override
    public Component createUi() {
        return this.assembler.createApplication(this);
    }
}

