/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.chat;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.teamapps.dto.UiChatDisplay;
import org.teamapps.dto.UiChatFile;
import org.teamapps.dto.UiChatMessage;
import org.teamapps.dto.UiChatPhoto;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.event.EventListener;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.chat.ChatDisplayModel;
import org.teamapps.ux.component.chat.ChatFile;
import org.teamapps.ux.component.chat.ChatMessage;
import org.teamapps.ux.component.chat.ChatMessageBatch;
import org.teamapps.ux.component.chat.ChatPhoto;
import org.teamapps.ux.resource.Resource;

public class ChatDisplay
extends AbstractComponent {
    private final ChatDisplayModel model;
    private int messagesFetchSize = 20;
    private final EventListener<ChatMessageBatch> modelAddMessagesAddedListener = chatMessages -> this.queueCommandIfRendered(() -> new UiChatDisplay.AddChatMessagesCommand(this.getId(), this.createUiChatMessages(chatMessages.getMessages()), false, chatMessages.isIncludesFirstMessage()));
    private final EventListener<Void> modelAllDataChangedListener = aVoid -> {
        ChatMessageBatch messageBatch = this.getModel().getLastChatMessages(this.messagesFetchSize);
        this.queueCommandIfRendered(() -> new UiChatDisplay.ReplaceChatMessagesCommand(this.getId(), this.createUiChatMessages(messageBatch.getMessages()), messageBatch.isIncludesFirstMessage()));
    };
    private Function<Resource, String> resourceToUrlConverter = resource -> {
        if (resource != null) {
            return this.getSessionContext().createResourceLink(() -> resource.getInputStream(), resource.getLength(), resource.getName());
        }
        return null;
    };

    public ChatDisplay(ChatDisplayModel model) {
        this.model = model;
        model.onMessagesAdded().addListener(this.modelAddMessagesAddedListener);
        model.onAllDataChanged().addListener(this.modelAllDataChangedListener);
    }

    public UiChatDisplay createUiComponent() {
        UiChatDisplay uiChatDisplay = new UiChatDisplay(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiChatDisplay);
        ChatMessageBatch modelResponse = this.model.getLastChatMessages(this.messagesFetchSize);
        uiChatDisplay.setMessages(this.createUiChatMessages(modelResponse.getMessages()));
        uiChatDisplay.setIncludesFirstMessage(modelResponse.isIncludesFirstMessage());
        return uiChatDisplay;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_CHAT_DISPLAY_PREVIOUS_MESSAGES_REQUESTED: {
                UiChatDisplay.PreviousMessagesRequestedEvent requestedEvent = (UiChatDisplay.PreviousMessagesRequestedEvent)event;
                ChatMessageBatch response = this.model.getPreviousMessages(requestedEvent.getEarliestKnownMessageId(), this.messagesFetchSize);
                this.queueCommandIfRendered(() -> new UiChatDisplay.AddChatMessagesCommand(this.getId(), this.createUiChatMessages(response.getMessages()), true, response.isIncludesFirstMessage()));
            }
        }
    }

    @NotNull
    private List<UiChatMessage> createUiChatMessages(List<ChatMessage> chatMessages) {
        return chatMessages.stream().map(message -> this.createUiChatMessage((ChatMessage)message)).collect(Collectors.toList());
    }

    private UiChatMessage createUiChatMessage(ChatMessage message) {
        UiChatMessage uiChatMessage = new UiChatMessage();
        uiChatMessage.setId(message.getId());
        uiChatMessage.setUserNickname(message.getUserNickname());
        uiChatMessage.setUserImageUrl(this.resourceToUrlConverter.apply(message.getUserImage()));
        uiChatMessage.setText(message.getText());
        uiChatMessage.setPhotos(message.getPhotos() != null ? message.getPhotos().stream().map(photo -> this.createUiChatPhoto((ChatPhoto)photo)).collect(Collectors.toList()) : null);
        uiChatMessage.setFiles(message.getFiles() != null ? message.getFiles().stream().map(file -> this.createUiChatFile((ChatFile)file)).collect(Collectors.toList()) : null);
        return uiChatMessage;
    }

    private UiChatPhoto createUiChatPhoto(ChatPhoto photo) {
        UiChatPhoto uiChatPhoto = new UiChatPhoto();
        uiChatPhoto.setThumbnailUrl(this.resourceToUrlConverter.apply(photo.getThumbnail()));
        uiChatPhoto.setImageUrl(this.resourceToUrlConverter.apply(photo.getImage()));
        return uiChatPhoto;
    }

    private UiChatFile createUiChatFile(ChatFile file) {
        UiChatFile uiChatFile = new UiChatFile();
        uiChatFile.setName(file.getName());
        uiChatFile.setIcon(this.getSessionContext().resolveIcon(file.getIcon()));
        uiChatFile.setThumbnailUrl(this.resourceToUrlConverter.apply(file.getThumbnail()));
        uiChatFile.setDownloadUrl(this.resourceToUrlConverter.apply(file.getDownload()));
        return uiChatFile;
    }

    @Override
    protected void doDestroy() {
        this.model.onMessagesAdded().removeListener(this.modelAddMessagesAddedListener);
        this.model.onAllDataChanged().removeListener(this.modelAllDataChangedListener);
    }

    public ChatDisplayModel getModel() {
        return this.model;
    }

    public int getMessagesFetchSize() {
        return this.messagesFetchSize;
    }

    public void setMessagesFetchSize(int messagesFetchSize) {
        this.messagesFetchSize = messagesFetchSize;
        this.reRenderIfRendered();
    }

    public Function<Resource, String> getResourceToUrlConverter() {
        return this.resourceToUrlConverter;
    }

    public void setResourceToUrlConverter(Function<Resource, String> resourceToUrlConverter) {
        this.resourceToUrlConverter = resourceToUrlConverter;
    }
}

