/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.MultiWriteLockableValue;

public abstract class AbstractField<VALUE>
extends AbstractComponent {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractField.class);
    public final Event<VALUE> onValueChanged = new Event();
    public final Event<Boolean> onVisibilityChanged = new Event();
    private FieldEditingMode editingMode = FieldEditingMode.EDITABLE;
    private boolean visible = true;
    private final List<FieldMessage> fieldMessages = new ArrayList<FieldMessage>(0);
    private MultiWriteLockableValue<VALUE> value = new MultiWriteLockableValue<Object>(null);

    public AbstractField() {
        this.getSessionContext().onDestroyed().addListener(aVoid -> this.destroy());
    }

    public FieldEditingMode getEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(FieldEditingMode editingMode) {
        this.editingMode = editingMode;
        this.queueCommandIfRendered(() -> new UiField.SetEditingModeCommand(this.getId(), editingMode.toUiFieldEditingMode()));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.queueCommandIfRendered(() -> new UiComponent.SetVisibleCommand(this.getId(), visible));
        this.onVisibilityChanged.fire(visible);
    }

    public void focus() {
        this.queueCommandIfRendered(() -> new UiField.FocusCommand(this.getId()));
    }

    protected void mapAbstractFieldAttributesToUiField(UiField uiField) {
        this.mapAbstractUiComponentProperties((UiComponent)uiField);
        uiField.setValue(this.convertUxValueToUiValue(this.value.read()));
        uiField.setEditingMode(this.editingMode.toUiFieldEditingMode());
        uiField.setVisible(this.visible);
        uiField.setFieldMessages(this.fieldMessages.stream().map(message -> message.createUiFieldMessage()).collect(Collectors.toList()));
    }

    public void setValue(VALUE value) {
        MultiWriteLockableValue.Lock lock = this.value.writeAndLock(value);
        Object uiValue = this.convertUxValueToUiValue(value);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiField.SetValueCommand(this.getId(), uiValue), aVoid -> lock.release());
        } else {
            lock.release();
        }
    }

    protected MultiWriteLockableValue.Lock setAndLockValue(VALUE value) {
        return this.value.writeAndLock(value);
    }

    public Object convertUxValueToUiValue(VALUE value) {
        return value;
    }

    public VALUE getValue() {
        return this.value.read();
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_FIELD_VALUE_CHANGED: {
                this.applyValueFromUi(((UiField.ValueChangedEvent)event).getValue());
            }
        }
    }

    protected void applyValueFromUi(Object value) {
        if (!this.value.isLocked()) {
            VALUE transformedValue = this.convertUiValueToUxValue(value);
            if (!this.value.isLocked()) {
                this.value.writeIfNotLocked(transformedValue);
                this.onValueChanged.fire(transformedValue);
            }
        }
    }

    public VALUE convertUiValueToUxValue(Object value) {
        return (VALUE)value;
    }

    @Override
    protected abstract void doDestroy();

    public List<FieldMessage> getFieldMessages() {
        return this.fieldMessages;
    }

    public void setFieldMessages(List<FieldMessage> fieldMessages) {
        this.fieldMessages.clear();
        this.fieldMessages.addAll(fieldMessages != null ? fieldMessages : Collections.emptyList());
        this.updateFieldMessages();
    }

    public void setValidationMessage(FieldMessage fieldMessage) {
        this.fieldMessages.removeIf(message -> message.getSeverity() != FieldMessage.Severity.INFO);
        this.fieldMessages.add(fieldMessage);
        this.updateFieldMessages();
    }

    public void removeValidationMessages() {
        if (this.fieldMessages.removeIf(message -> message.getSeverity() != FieldMessage.Severity.INFO)) {
            this.updateFieldMessages();
        }
    }

    public void addFieldMessage(FieldMessage fieldMessage) {
        this.fieldMessages.add(fieldMessage);
        this.updateFieldMessages();
    }

    public void removeFieldMessage(FieldMessage fieldMessage) {
        this.fieldMessages.remove(fieldMessage);
        this.updateFieldMessages();
    }

    public void removeFieldMessages(List<FieldMessage> fieldMessages) {
        fieldMessages.removeAll(fieldMessages);
        this.updateFieldMessages();
    }

    private void updateFieldMessages() {
        this.queueCommandIfRendered(() -> new UiField.SetFieldMessagesCommand(this.getId(), this.fieldMessages.stream().map(message -> message.createUiFieldMessage()).collect(Collectors.toList())));
    }
}

