/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.ux.component.form.layoutpolicy.FormSection;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionFieldPlacement;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.SizeType;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;

public class ResponsiveFormConfigurationTemplate {
    private FormSection sectionTemplate;
    private FormSectionFieldPlacement placementTemplate;
    private Map<Integer, FormSectionFieldPlacement> placementTemplateByColumn = new HashMap<Integer, FormSectionFieldPlacement>();
    private GridRow rowTemplate;
    private GridRow emptyRowTemplate;
    private GridRow singleColumnRowTemplate;
    private GridColumn columnTemplate;
    private GridColumn emptyColumnTemplate;
    private GridColumn singleColumnColumnTemplate;
    private Map<Integer, GridColumn> columnTemplateByColumn = new HashMap<Integer, GridColumn>();

    public static ResponsiveFormConfigurationTemplate createDefaultTwoColumnTemplate(int fieldMinWidth, int fieldMaxWidth) {
        return ResponsiveFormConfigurationTemplate.createDefaultTwoColumnTemplate(0, fieldMinWidth, fieldMaxWidth);
    }

    public static ResponsiveFormConfigurationTemplate createDefaultTwoColumnTemplate(int minLabelWidth, int fieldMinWidth, int fieldMaxWidth) {
        ResponsiveFormConfigurationTemplate template = new ResponsiveFormConfigurationTemplate();
        template.setSectionTemplate(new FormSection(null).setCollapsible(true).setPadding(new Spacing(5)).setMargin(new Spacing(5)).setGridGap(0));
        template.setRowTemplate(new GridRow(new SizingPolicy(SizeType.AUTO, 0.0f, 0), 2, 2));
        template.setEmptyRowTemplate(new GridRow(new SizingPolicy(SizeType.AUTO, 0.0f, 0), 0, 0));
        template.setPlacementTemplate(new FormSectionFieldPlacement().setHorizontalAlignment(HorizontalElementAlignment.LEFT).setVerticalAlignment(VerticalElementAlignment.CENTER));
        FormSectionFieldPlacement labelPlacement = new FormSectionFieldPlacement().setHorizontalAlignment(HorizontalElementAlignment.LEFT).setVerticalAlignment(VerticalElementAlignment.CENTER).setMinWidth(minLabelWidth);
        FormSectionFieldPlacement fieldPlacement = new FormSectionFieldPlacement().setHorizontalAlignment(HorizontalElementAlignment.STRETCH).setVerticalAlignment(VerticalElementAlignment.CENTER).setMinWidth(fieldMinWidth).setMaxWidth(fieldMaxWidth);
        template.setPlacementTemplateByColumn(0, labelPlacement);
        template.setPlacementTemplateByColumn(1, fieldPlacement);
        template.setPlacementTemplateByColumn(2, labelPlacement);
        template.setPlacementTemplateByColumn(3, fieldPlacement);
        template.setColumnTemplate(new GridColumn(new SizingPolicy(SizeType.AUTO, 0.0f, 0), 0, 10));
        template.setColumnTemplateByColumn(1, new GridColumn(new SizingPolicy(SizeType.FRACTION, 1.0f, 0), 0, 10));
        return template;
    }

    public static ResponsiveFormConfigurationTemplate createDefault() {
        ResponsiveFormConfigurationTemplate template = new ResponsiveFormConfigurationTemplate();
        template.setSectionTemplate(new FormSection(null).setCollapsible(true).setPadding(new Spacing(5)).setMargin(new Spacing(5)).setGridGap(0));
        template.setPlacementTemplate(new FormSectionFieldPlacement().setHorizontalAlignment(HorizontalElementAlignment.STRETCH).setVerticalAlignment(VerticalElementAlignment.CENTER));
        template.setRowTemplate(new GridRow(new SizingPolicy(SizeType.AUTO, 0.0f, 0), 2, 2));
        template.setEmptyRowTemplate(new GridRow(new SizingPolicy(SizeType.AUTO, 0.0f, 0), 0, 0));
        template.setColumnTemplate(new GridColumn(new SizingPolicy(SizeType.FRACTION, 1.0f, 0), 0, 10));
        return template;
    }

    public FormSectionFieldPlacement createFieldPlacementTemplate(int column) {
        FormSectionFieldPlacement<Object> fieldPlacement = this.placementTemplateByColumn.get(column);
        if (fieldPlacement == null && this.placementTemplate != null) {
            fieldPlacement = this.placementTemplate.createCopy();
        }
        if (fieldPlacement == null) {
            fieldPlacement = new FormSectionFieldPlacement<Object>(null, 0, 0);
        }
        return fieldPlacement;
    }

    public GridRow createRowTemplate(boolean emptyCell, boolean singleColumnLayout) {
        if (singleColumnLayout && this.singleColumnRowTemplate != null) {
            return new GridRow(this.singleColumnRowTemplate);
        }
        GridRow row = null;
        if (this.rowTemplate != null) {
            row = new GridRow(this.rowTemplate);
        }
        if (emptyCell && this.emptyRowTemplate != null) {
            row = this.emptyRowTemplate;
        }
        if (row == null) {
            row = new GridRow();
        }
        return row;
    }

    public GridColumn createColumnTemplate(int column, boolean emptyCell, boolean singleColumnLayout) {
        if (singleColumnLayout && this.singleColumnColumnTemplate != null) {
            return this.singleColumnColumnTemplate;
        }
        GridColumn colTemplate = null;
        GridColumn templateByColumn = this.columnTemplateByColumn.get(column);
        if (templateByColumn != null) {
            colTemplate = new GridColumn(templateByColumn);
        }
        if (colTemplate == null && this.columnTemplate != null) {
            colTemplate = new GridColumn(this.columnTemplate);
        }
        if (emptyCell && this.emptyColumnTemplate != null) {
            colTemplate = this.emptyColumnTemplate;
        }
        if (colTemplate == null) {
            colTemplate = new GridColumn();
        }
        return colTemplate;
    }

    public FormSection getSectionTemplate() {
        return this.sectionTemplate;
    }

    public void setSectionTemplate(FormSection sectionTemplate) {
        this.sectionTemplate = sectionTemplate;
    }

    public FormSectionFieldPlacement getPlacementTemplate() {
        return this.placementTemplate;
    }

    public void setPlacementTemplate(FormSectionFieldPlacement placementTemplate) {
        this.placementTemplate = placementTemplate;
    }

    public void setPlacementTemplateByColumn(int column, FormSectionFieldPlacement placementTemplate) {
        this.placementTemplateByColumn.put(column, placementTemplate);
    }

    public GridRow getRowTemplate() {
        return this.rowTemplate;
    }

    public void setRowTemplate(GridRow rowTemplate) {
        this.rowTemplate = rowTemplate;
    }

    public GridRow getEmptyRowTemplate() {
        return this.emptyRowTemplate;
    }

    public void setEmptyRowTemplate(GridRow emptyRowTemplate) {
        this.emptyRowTemplate = emptyRowTemplate;
    }

    public GridRow getSingleColumnRowTemplate() {
        return this.singleColumnRowTemplate;
    }

    public void setSingleColumnRowTemplate(GridRow singleColumnRowTemplate) {
        this.singleColumnRowTemplate = singleColumnRowTemplate;
    }

    public GridColumn getColumnTemplate() {
        return this.columnTemplate;
    }

    public void setColumnTemplate(GridColumn columnTemplate) {
        this.columnTemplate = columnTemplate;
    }

    public void setColumnTemplateByColumn(int column, GridColumn columnTemplate) {
        this.columnTemplateByColumn.put(column, columnTemplate);
    }

    public GridColumn getEmptyColumnTemplate() {
        return this.emptyColumnTemplate;
    }

    public void setEmptyColumnTemplate(GridColumn emptyColumnTemplate) {
        this.emptyColumnTemplate = emptyColumnTemplate;
    }

    public GridColumn getSingleColumnColumnTemplate() {
        return this.singleColumnColumnTemplate;
    }

    public void setSingleColumnColumnTemplate(GridColumn singleColumnColumnTemplate) {
        this.singleColumnColumnTemplate = singleColumnColumnTemplate;
    }
}

