/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.itemview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiItemViewItemGroup;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.itemview.ItemGroupContainer;
import org.teamapps.ux.component.itemview.ItemViewFloatStyle;
import org.teamapps.ux.component.itemview.ItemViewItemJustification;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class ItemGroup<HEADERRECORD, RECORD> {
    private final String clientId = UUID.randomUUID().toString();
    private List<RECORD> items = new ArrayList<RECORD>();
    private Template itemTemplate;
    private HEADERRECORD headerRecord;
    private boolean headerVisible = true;
    private ItemViewFloatStyle floatStyle = ItemViewFloatStyle.HORIZONTAL_FLOAT;
    private ItemViewItemJustification itemJustification = ItemViewItemJustification.LEFT;
    private float buttonWidth = -1.0f;
    private int horizontalPadding = 0;
    private int verticalPadding = 0;
    private int horizontalItemMargin = 0;
    private int verticalItemMargin = 0;
    private ItemGroupContainer<HEADERRECORD, RECORD> container;
    private PropertyExtractor<RECORD> itemPropertyExtractor = new BeanPropertyExtractor();
    private final ClientRecordCache<RECORD, UiIdentifiableClientRecord> itemCache = new ClientRecordCache<Object, UiIdentifiableClientRecord>(this::createUiIdentifiableClientRecord);

    public ItemGroup() {
        this(null);
    }

    public ItemGroup(HEADERRECORD headerRecord) {
        this(headerRecord, null);
    }

    public ItemGroup(HEADERRECORD headerRecord, Template itemTemplate) {
        this(headerRecord, itemTemplate, null);
    }

    public ItemGroup(HEADERRECORD headerRecord, Template itemTemplate, List<RECORD> items) {
        this.itemTemplate = itemTemplate == null ? BaseTemplate.ITEM_VIEW_ITEM : itemTemplate;
        this.headerRecord = headerRecord;
        this.items.addAll(items != null ? items : Collections.emptyList());
    }

    public UiItemViewItemGroup createUiItemViewItemGroup() {
        UiItemViewItemGroup itemGroup = new UiItemViewItemGroup(this.itemTemplate.createUiTemplate());
        itemGroup.setId(this.clientId);
        if (this.headerRecord != null) {
            itemGroup.setHeaderData(this.container.createHeaderClientRecord(this.headerRecord));
        }
        CacheManipulationHandle<List<UiIdentifiableClientRecord>> cacheResponse = this.itemCache.replaceRecords(this.items);
        cacheResponse.commit();
        itemGroup.setItems(cacheResponse.getResult());
        itemGroup.setHeaderVisible(this.headerVisible);
        itemGroup.setFloatStyle(this.floatStyle.toUiItemViewFloatStyle());
        itemGroup.setButtonWidth(this.buttonWidth);
        itemGroup.setHorizontalPadding(this.horizontalPadding);
        itemGroup.setVerticalPadding(this.verticalPadding);
        itemGroup.setHorizontalItemMargin(this.horizontalItemMargin);
        itemGroup.setVerticalItemMargin(this.verticalItemMargin);
        itemGroup.setItemJustification(this.itemJustification.toUiItemJustification());
        return itemGroup;
    }

    private UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
        clientRecord.setValues(this.itemPropertyExtractor.getValues(record, this.itemTemplate.getDataKeys()));
        return clientRecord;
    }

    public void setContainer(ItemGroupContainer<HEADERRECORD, RECORD> container) {
        this.container = container;
    }

    public void addItem(RECORD item) {
        if (this.items.contains(item)) {
            return;
        }
        this.items.add(item);
        if (this.container != null) {
            CacheManipulationHandle<UiIdentifiableClientRecord> cacheResponse = this.itemCache.addRecord(item);
            this.container.handleAddItem(cacheResponse.getResult(), aVoid -> cacheResponse.commit());
        }
    }

    public void removeItem(RECORD item) {
        boolean removed = this.items.remove(item);
        if (removed) {
            CacheManipulationHandle<Integer> cacheResponse = this.itemCache.removeRecord(item);
            this.container.handleRemoveItem(cacheResponse.getResult(), aVoid -> cacheResponse.commit());
        }
    }

    public List<RECORD> getItems() {
        return this.items;
    }

    private void requireRefresh() {
        if (this.container != null) {
            this.container.handleRefreshRequired();
        }
    }

    public ItemGroup setItems(List<RECORD> items) {
        this.items = items;
        this.requireRefresh();
        return this;
    }

    public Template getItemTemplate() {
        return this.itemTemplate;
    }

    public ItemGroup setItemTemplate(Template itemTemplate) {
        this.itemTemplate = itemTemplate;
        this.requireRefresh();
        return this;
    }

    public HEADERRECORD getHeaderRecord() {
        return this.headerRecord;
    }

    public ItemGroup setHeaderRecord(HEADERRECORD headerRecord) {
        this.headerRecord = headerRecord;
        this.requireRefresh();
        return this;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public ItemGroup setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
        this.requireRefresh();
        return this;
    }

    public ItemViewFloatStyle getFloatStyle() {
        return this.floatStyle;
    }

    public ItemGroup setFloatStyle(ItemViewFloatStyle floatStyle) {
        this.floatStyle = floatStyle;
        this.requireRefresh();
        return this;
    }

    public float getButtonWidth() {
        return this.buttonWidth;
    }

    public ItemGroup setButtonWidth(float buttonWidth) {
        this.buttonWidth = buttonWidth;
        this.requireRefresh();
        return this;
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    public ItemGroup setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        this.requireRefresh();
        return this;
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public ItemGroup setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        this.requireRefresh();
        return this;
    }

    public int getHorizontalItemMargin() {
        return this.horizontalItemMargin;
    }

    public ItemGroup setHorizontalItemMargin(int horizontalItemMargin) {
        this.horizontalItemMargin = horizontalItemMargin;
        this.requireRefresh();
        return this;
    }

    public int getVerticalItemMargin() {
        return this.verticalItemMargin;
    }

    public ItemGroup setVerticalItemMargin(int verticalItemMargin) {
        this.verticalItemMargin = verticalItemMargin;
        this.requireRefresh();
        return this;
    }

    public ItemViewItemJustification getItemJustification() {
        return this.itemJustification;
    }

    public ItemGroup setItemJustification(ItemViewItemJustification itemJustification) {
        this.itemJustification = itemJustification;
        this.requireRefresh();
        return this;
    }

    public ItemGroupContainer<HEADERRECORD, RECORD> getContainer() {
        return this.container;
    }

    public PropertyExtractor<RECORD> getItemPropertyExtractor() {
        return this.itemPropertyExtractor;
    }

    public void setItemPropertyExtractor(PropertyExtractor<RECORD> itemPropertyExtractor) {
        this.itemPropertyExtractor = itemPropertyExtractor;
        this.requireRefresh();
    }

    RECORD getItemByClientId(int clientId) {
        return this.itemCache.getRecordByClientId(clientId);
    }

    String getClientId() {
        return this.clientId;
    }
}

