/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.session.LockableSessionContext;
import org.teamapps.ux.session.SessionContext;

public class CurrentSessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentSessionContext.class);
    private static final ThreadLocal<Deque<LockableSessionContext>> CURRENT_CONTEXT = new ThreadLocal();

    @NotNull
    public static SessionContext get() {
        LockableSessionContext sessionContext = CurrentSessionContext.getContextStack().peekLast();
        if (sessionContext == null) {
            String errorMessage = "CurrentSessionContext is not set but requested! Please use SessionContext.runWithContext(Runnable) to set the context.";
            IllegalStateException illegalStateException = new IllegalStateException(errorMessage);
            LOGGER.error(errorMessage, (Throwable)illegalStateException);
            throw illegalStateException;
        }
        return sessionContext;
    }

    public static LockableSessionContext getOrNull() {
        return CurrentSessionContext.getContextStack().peekLast();
    }

    static void pushContext(LockableSessionContext sessionContext) {
        CurrentSessionContext.getContextStack().addLast(sessionContext);
    }

    static void popContext() {
        CurrentSessionContext.getContextStack().removeLast();
    }

    private static Deque<LockableSessionContext> getContextStack() {
        Deque<LockableSessionContext> contextStack = CURRENT_CONTEXT.get();
        if (contextStack == null) {
            contextStack = new ArrayDeque<LockableSessionContext>();
            CURRENT_CONTEXT.set(contextStack);
        }
        return contextStack;
    }
}

