/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.webcontroller;

import java.util.function.Function;
import org.teamapps.common.format.Color;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class SimpleWebController
implements WebController {
    public static final String BACKGROUND_DEFAULT = "default";
    private final Function<SessionContext, Component> componentSupplier;
    private boolean showBackgroundImage;
    private Color defaultBackgroundColor;

    public static WebController createDefaultController(Function<SessionContext, Component> componentSupplier) {
        return SimpleWebController.createDefaultController(componentSupplier, Color.WHITE, false);
    }

    public static WebController createDefaultController(Function<SessionContext, Component> componentSupplier, Color defaultBackgroundColor) {
        return SimpleWebController.createDefaultController(componentSupplier, defaultBackgroundColor, false);
    }

    public static WebController createDefaultController(Function<SessionContext, Component> componentSupplier, Color defaultBackgroundColor, boolean showBackgroundImage) {
        SimpleWebController webController = new SimpleWebController(componentSupplier);
        webController.setDefaultBackgroundColor(defaultBackgroundColor);
        webController.setShowBackgroundImage(showBackgroundImage);
        return webController;
    }

    public SimpleWebController(Function<SessionContext, Component> componentSupplier) {
        this.componentSupplier = componentSupplier;
    }

    public void setShowBackgroundImage(boolean showBackgroundImage) {
        this.showBackgroundImage = showBackgroundImage;
    }

    public void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
    }

    @Override
    public void onSessionStart(SessionContext context) {
        if (this.showBackgroundImage) {
            String defaultBackground = "/resources/backgrounds/default-bl.jpg";
            context.registerBackgroundImage(BACKGROUND_DEFAULT, defaultBackground, defaultBackground);
        }
        RootPanel rootPanel = new RootPanel();
        context.addRootComponent(null, rootPanel);
        rootPanel.setContent(this.componentSupplier.apply(context));
        if (this.defaultBackgroundColor != null) {
            context.setBackgroundColor(this.defaultBackgroundColor, 0);
        }
        if (this.showBackgroundImage) {
            context.setBackgroundImage(BACKGROUND_DEFAULT, 0);
        }
    }
}

