/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.ClassAndPropertyName;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.util.ReflectionUtil;

public class BeanPropertyExtractor<RECORD>
implements PropertyExtractor<RECORD> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanPropertyExtractor.class);
    private static final Map<ClassAndPropertyName, ValueExtractor> gettersByClassAndPropertyName = new ConcurrentHashMap<ClassAndPropertyName, ValueExtractor>();
    private final Map<String, ValueExtractor<RECORD>> customExtractors = new HashMap<String, ValueExtractor<RECORD>>(0);

    @Override
    public Object getValue(RECORD record, String propertyName) {
        ValueExtractor<RECORD> valueExtractor = this.getValueExtractor(record.getClass(), propertyName);
        return valueExtractor.extract(record);
    }

    protected ValueExtractor<RECORD> getValueExtractor(Class clazz, String propertyName) {
        ValueExtractor<RECORD> valueExtractor = this.customExtractors.get(propertyName);
        if (valueExtractor != null) {
            return valueExtractor;
        }
        return gettersByClassAndPropertyName.computeIfAbsent(new ClassAndPropertyName(clazz, propertyName), classAndPropertyName -> this.createValueExtractor((ClassAndPropertyName)classAndPropertyName));
    }

    private ValueExtractor<RECORD> createValueExtractor(ClassAndPropertyName classAndPropertyName) {
        Method getter = ReflectionUtil.findGetter(classAndPropertyName.clazz, classAndPropertyName.propertyName);
        return record -> {
            if (getter != null) {
                return ReflectionUtil.invokeMethod(record, getter, new Object[0]);
            }
            LOGGER.debug("Could not find getter for property {} on class {}!", (Object)classAndPropertyName.propertyName, (Object)record.getClass().getCanonicalName());
            return null;
        };
    }

    public BeanPropertyExtractor<RECORD> addProperty(String propertyName, ValueExtractor<RECORD> valueExtractor) {
        this.customExtractors.put(propertyName, valueExtractor);
        return this;
    }
}

