/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiFieldGroup;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.flexcontainer.FlexSizeUnit;
import org.teamapps.ux.component.flexcontainer.FlexSizingPolicy;

public class FieldGroup
extends AbstractComponent {
    private List<AbstractField> fields = new ArrayList<AbstractField>();

    public UiFieldGroup createUiComponent() {
        UiFieldGroup uiFieldGroup = new UiFieldGroup();
        this.mapAbstractUiComponentProperties((UiComponent)uiFieldGroup);
        uiFieldGroup.setFields(this.createUiFieldReferences());
        return uiFieldGroup;
    }

    private List<UiClientObjectReference> createUiFieldReferences() {
        return this.fields.stream().map(c -> c.createUiReference()).collect(Collectors.toList());
    }

    private void addField(AbstractField field, int index) {
        this.fields.remove(field);
        if (index > this.fields.size()) {
            index = this.fields.size();
        }
        this.fields.add(index, field);
        this.queueCommandIfRendered(() -> new UiFieldGroup.SetFieldsCommand(this.getId(), this.createUiFieldReferences()));
    }

    public void addField(AbstractField field, FlexSizingPolicy sizingPolicy) {
        field.setCssStyle("flex", sizingPolicy.toCssValue());
        this.addField(field, this.fields.size());
    }

    public void addFieldFillRemaining(AbstractField field) {
        this.addField(field, new FlexSizingPolicy(1.0f, FlexSizeUnit.PIXEL, 1, 1));
    }

    public void addFieldAutoSize(AbstractField field) {
        this.addField(field, new FlexSizingPolicy(0, 0));
    }

    public void addField(AbstractField field, FlexSizingPolicy sizingPolicy, int index) {
        field.setCssStyle("flex", sizingPolicy.toCssValue());
        this.addField(field, index);
    }

    public void addFieldFillRemaining(AbstractField field, int index) {
        this.addField(field, new FlexSizingPolicy(1.0f, FlexSizeUnit.PIXEL, 1, 1), index);
    }

    public void addFieldAutoSize(AbstractField field, int index) {
        this.addField(field, new FlexSizingPolicy(0, 0), index);
    }

    public void removeField(AbstractField field) {
        this.fields.remove(field);
        this.queueCommandIfRendered(() -> new UiFieldGroup.SetFieldsCommand(this.getId(), this.createUiFieldReferences()));
    }
}

