/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.combobox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiComboBox;
import org.teamapps.dto.UiComboBoxTreeRecord;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiTextInputHandlingField;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.TextMatchingMode;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.node.TreeNode;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoExtractor;
import org.teamapps.ux.model.BaseTreeModel;

public abstract class AbstractComboBox<COMPONENT extends AbstractComboBox, RECORD, VALUE>
extends AbstractField<VALUE>
implements TextInputHandlingField {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComboBox.class);
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    protected final ClientRecordCache<RECORD, UiComboBoxTreeRecord> recordCache;
    private BaseTreeModel<RECORD> model;
    private List<RECORD> staticData = new ArrayList<RECORD>();
    private TextMatchingMode textMatchingMode = TextMatchingMode.CONTAINS;
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private int templateIdCounter = 0;
    private Template selectedEntryTemplate = null;
    private Template dropDownTemplate = null;
    private TemplateDecider<RECORD> selectedEntryTemplateDecider = record -> this.selectedEntryTemplate;
    private TemplateDecider<RECORD> dropdownTemplateDecider = record -> this.dropDownTemplate;
    private boolean showDropDownButton = true;
    private boolean showDropDownAfterResultsArrive = false;
    private boolean highlightFirstResultEntry = true;
    private boolean autoComplete = true;
    private boolean showHighlighting = false;
    private int textHighlightingEntryLimit = 100;
    private boolean allowFreeText;
    private boolean showClearButton;
    private boolean animate = true;
    private boolean showExpanders = false;
    private Function<RECORD, String> recordToStringFunction = Object::toString;
    protected Function<String, RECORD> freeTextRecordFactory = null;
    private TreeNodeInfoExtractor<RECORD> treeNodeInfoExtractor = record -> {
        if (record instanceof TreeNode) {
            return (TreeNode)record;
        }
        return null;
    };

    private AbstractComboBox(List<RECORD> staticData, BaseTreeModel<RECORD> model) {
        this.model = model;
        if (staticData != null) {
            this.staticData = new ArrayList<RECORD>(staticData);
        }
        this.recordCache = new ClientRecordCache<Object, UiComboBoxTreeRecord>(this::createUiTreeRecordWithoutParentRelation, this::addParentLinkToUiRecord);
    }

    protected AbstractComboBox(BaseTreeModel<RECORD> model) {
        this(null, model);
    }

    public AbstractComboBox(List<RECORD> staticData) {
        this(staticData, null);
    }

    protected void mapCommonUiComboBoxProperties(UiComboBox comboBox) {
        this.mapAbstractFieldAttributesToUiField((UiField)comboBox);
        if (this.staticData != null) {
            CacheManipulationHandle<List<UiComboBoxTreeRecord>> cacheResponse = this.recordCache.replaceRecords(this.staticData);
            cacheResponse.commit();
            comboBox.setStaticData(cacheResponse.getAndClearResult());
        }
        comboBox.setTemplates(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        comboBox.setTextMatchingMode(this.textMatchingMode.toUiTextMatchingMode());
        comboBox.setShowDropDownButton(this.showDropDownButton);
        comboBox.setShowDropDownAfterResultsArrive(this.showDropDownAfterResultsArrive);
        comboBox.setHighlightFirstResultEntry(this.highlightFirstResultEntry);
        comboBox.setShowHighlighting(this.showHighlighting);
        comboBox.setAutoComplete(this.autoComplete);
        comboBox.setTextHighlightingEntryLimit(this.textHighlightingEntryLimit);
        comboBox.setAllowAnyText(this.allowFreeText);
        comboBox.setShowClearButton(this.showClearButton);
        comboBox.setAnimate(this.animate);
        comboBox.setShowExpanders(this.showExpanders);
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_TEXT_INPUT_HANDLING_FIELD_TEXT_INPUT: {
                UiTextInputHandlingField.TextInputEvent keyStrokeEvent = (UiTextInputHandlingField.TextInputEvent)event;
                if (this.model != null) {
                    List<RECORD> records = this.model.getRecords(keyStrokeEvent.getEnteredString());
                    CacheManipulationHandle<List<UiComboBoxTreeRecord>> cacheResponse = this.recordCache.replaceRecords(records);
                    if (this.isRendered()) {
                        this.getSessionContext().queueCommand(new UiComboBox.SetDropDownDataCommand(this.getId(), cacheResponse.getAndClearResult()), aVoid -> cacheResponse.commit());
                    } else {
                        cacheResponse.commit();
                    }
                }
                this.onTextInput.fire(keyStrokeEvent.getEnteredString());
                break;
            }
            case UI_TEXT_INPUT_HANDLING_FIELD_SPECIAL_KEY_PRESSED: {
                UiTextInputHandlingField.SpecialKeyPressedEvent specialKeyPressedEvent = (UiTextInputHandlingField.SpecialKeyPressedEvent)event;
                this.onSpecialKeyPressed.fire(SpecialKey.valueOf(specialKeyPressedEvent.getKey().name()));
                break;
            }
            case UI_COMBO_BOX_LAZY_CHILD_DATA_REQUESTED: {
                UiComboBox.LazyChildDataRequestedEvent lazyChildDataRequestedEvent = (UiComboBox.LazyChildDataRequestedEvent)event;
                RECORD parentRecord = this.recordCache.getRecordByClientId(lazyChildDataRequestedEvent.getParentId());
                if (parentRecord == null || this.model == null) break;
                List<RECORD> childRecords = this.model.getChildRecords(parentRecord);
                CacheManipulationHandle<List<UiComboBoxTreeRecord>> cacheResponse = this.recordCache.addRecords(childRecords);
                if (this.isRendered()) {
                    this.getSessionContext().queueCommand(new UiComboBox.SetChildNodesCommand(this.getId(), lazyChildDataRequestedEvent.getParentId(), cacheResponse.getAndClearResult()), aVoid -> cacheResponse.commit());
                    break;
                }
                cacheResponse.commit();
            }
        }
    }

    protected UiComboBoxTreeRecord createUiTreeRecordWithoutParentRelation(RECORD record) {
        if (record == null) {
            return null;
        }
        Template displayTemplate = this.getTemplateForRecord(record, this.selectedEntryTemplateDecider, this.selectedEntryTemplate);
        Template dropdownTemplate = this.getTemplateForRecord(record, this.dropdownTemplateDecider, this.dropDownTemplate);
        HashSet<String> templateDataKeys = new HashSet<String>();
        templateDataKeys.addAll(displayTemplate != null ? displayTemplate.getDataKeys() : Collections.emptySet());
        templateDataKeys.addAll(dropdownTemplate != null ? dropdownTemplate.getDataKeys() : Collections.emptySet());
        Map<String, Object> values = this.propertyExtractor.getValues(record, templateDataKeys);
        UiComboBoxTreeRecord uiTreeRecord = new UiComboBoxTreeRecord();
        uiTreeRecord.setValues(values);
        uiTreeRecord.setDisplayTemplateId(this.templateIdsByTemplate.get(displayTemplate));
        uiTreeRecord.setDropDownTemplateId(this.templateIdsByTemplate.get(dropdownTemplate));
        uiTreeRecord.setAsString(this.recordToStringFunction.apply(record));
        TreeNodeInfo treeNodeInfo = this.treeNodeInfoExtractor.getTreeNodeInfo(record);
        if (treeNodeInfo != null) {
            uiTreeRecord.setExpanded(treeNodeInfo.isExpanded());
            uiTreeRecord.setLazyChildren(treeNodeInfo.isLazyChildren());
        }
        return uiTreeRecord;
    }

    protected void addParentLinkToUiRecord(RECORD record, UiComboBoxTreeRecord uiTreeRecord, Map<RECORD, UiComboBoxTreeRecord> othersCurrentlyBeingAddedToCache) {
        Object parent;
        TreeNodeInfo treeNodeInfo = this.treeNodeInfoExtractor.getTreeNodeInfo(record);
        if (treeNodeInfo != null && (parent = treeNodeInfo.getParent()) != null) {
            UiComboBoxTreeRecord uiParentFromOthers = othersCurrentlyBeingAddedToCache.get(parent);
            if (uiParentFromOthers != null) {
                uiTreeRecord.setParentId(Integer.valueOf(uiParentFromOthers.getId()));
            } else {
                Integer cachedParentUiRecordId = this.recordCache.getUiRecordIdOrNull(parent);
                if (cachedParentUiRecordId != null) {
                    uiTreeRecord.setParentId(cachedParentUiRecordId);
                }
            }
        }
    }

    private Template getTemplateForRecord(RECORD record, TemplateDecider<RECORD> templateDecider, Template defaultTemplate) {
        Template template;
        Template templateFromDecider = templateDecider.getTemplate(record);
        Template template2 = template = templateFromDecider != null ? templateFromDecider : defaultTemplate;
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String uuid = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, uuid);
            this.queueCommandIfRendered(() -> new UiComboBox.RegisterTemplateCommand(this.getId(), uuid, template.createUiTemplate()));
        }
        return template;
    }

    protected boolean isFreeTextEntry(UiComboBoxTreeRecord uiTreeRecord) {
        return uiTreeRecord.getId() < 0;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public List<RECORD> getStaticData() {
        return this.staticData;
    }

    public void setStaticData(List<RECORD> staticData) {
        this.staticData = staticData;
        this.model = null;
        this.reRenderIfRendered();
    }

    public void addDropDownItem(RECORD record) {
        if (this.staticData == null) {
            this.staticData = new ArrayList<RECORD>();
        }
        this.staticData.add(record);
        this.reRenderIfRendered();
    }

    public void addDropDownItems(RECORD ... records) {
        if (this.staticData == null) {
            this.staticData = new ArrayList<RECORD>();
        }
        this.staticData.addAll(Arrays.asList(records));
        this.reRenderIfRendered();
    }

    public void addDropDownItems(List<RECORD> records) {
        if (this.staticData == null) {
            this.staticData = new ArrayList<RECORD>();
        }
        this.staticData.addAll(records);
        this.reRenderIfRendered();
    }

    public BaseTreeModel getModel() {
        return this.model;
    }

    public void setModel(BaseTreeModel<RECORD> model) {
        this.model = model;
        this.staticData = null;
        this.reRenderIfRendered();
    }

    public TextMatchingMode getTextMatchingMode() {
        return this.textMatchingMode;
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public boolean isShowDropDownAfterResultsArrive() {
        return this.showDropDownAfterResultsArrive;
    }

    public boolean isHighlightFirstResultEntry() {
        return this.highlightFirstResultEntry;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public boolean isShowHighlighting() {
        return this.showHighlighting;
    }

    public int getTextHighlightingEntryLimit() {
        return this.textHighlightingEntryLimit;
    }

    public boolean isAllowFreeText() {
        return this.allowFreeText;
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.reRenderIfRendered();
    }

    public void setShowDropDownAfterResultsArrive(boolean showDropDownAfterResultsArrive) {
        this.showDropDownAfterResultsArrive = showDropDownAfterResultsArrive;
        this.reRenderIfRendered();
    }

    public void setHighlightFirstResultEntry(boolean highlightFirstResultEntry) {
        this.highlightFirstResultEntry = highlightFirstResultEntry;
        this.reRenderIfRendered();
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
        this.reRenderIfRendered();
    }

    public void setShowHighlighting(boolean showHighlighting) {
        this.showHighlighting = showHighlighting;
        this.reRenderIfRendered();
    }

    public void setAllowFreeText(boolean allowFreeText) {
        this.allowFreeText = allowFreeText;
        this.reRenderIfRendered();
    }

    public void setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.reRenderIfRendered();
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
        this.reRenderIfRendered();
    }

    public boolean isShowExpanders() {
        return this.showExpanders;
    }

    public void setShowExpanders(boolean showExpanders) {
        this.showExpanders = showExpanders;
        this.reRenderIfRendered();
    }

    public void setTextMatchingMode(TextMatchingMode textMatchingMode) {
        this.textMatchingMode = textMatchingMode;
        this.reRenderIfRendered();
    }

    public void setSelectedEntryTemplate(Template selectedEntryTemplate) {
        this.selectedEntryTemplate = selectedEntryTemplate;
        this.templateIdsByTemplate.put(selectedEntryTemplate, "" + this.templateIdCounter++);
        this.reRenderIfRendered();
    }

    public void setDropDownTemplate(Template dropDownTemplate) {
        this.dropDownTemplate = dropDownTemplate;
        this.templateIdsByTemplate.put(dropDownTemplate, "" + this.templateIdCounter++);
        this.reRenderIfRendered();
    }

    public void setTemplate(Template template) {
        this.setSelectedEntryTemplate(template);
        this.setDropDownTemplate(template);
    }

    public void setTextHighlightingEntryLimit(int textHighlightingEntryLimit) {
        this.textHighlightingEntryLimit = textHighlightingEntryLimit;
        this.reRenderIfRendered();
    }

    public Template getSelectedEntryTemplate() {
        return this.selectedEntryTemplate;
    }

    public Template getDropDownTemplate() {
        return this.dropDownTemplate;
    }

    public TemplateDecider<RECORD> getSelectedEntryTemplateDecider() {
        return this.selectedEntryTemplateDecider;
    }

    public void setSelectedEntryTemplateDecider(TemplateDecider<RECORD> selectedEntryTemplateDecider) {
        this.selectedEntryTemplateDecider = selectedEntryTemplateDecider;
    }

    public TemplateDecider<RECORD> getDropdownTemplateDecider() {
        return this.dropdownTemplateDecider;
    }

    public void setDropdownTemplateDecider(TemplateDecider<RECORD> dropdownTemplateDecider) {
        this.dropdownTemplateDecider = dropdownTemplateDecider;
    }

    public void setTemplateDecider(TemplateDecider<RECORD> templateDecider) {
        this.selectedEntryTemplateDecider = templateDecider;
        this.dropdownTemplateDecider = templateDecider;
        this.reRenderIfRendered();
    }

    public Function<String, RECORD> getFreeTextRecordFactory() {
        return this.freeTextRecordFactory;
    }

    public void setFreeTextRecordFactory(Function<String, RECORD> freeTextRecordFactory) {
        this.freeTextRecordFactory = freeTextRecordFactory;
        this.reRenderIfRendered();
    }

    public Function<RECORD, String> getRecordToStringFunction() {
        return this.recordToStringFunction;
    }

    public void setRecordToStringFunction(Function<RECORD, String> recordToStringFunction) {
        this.recordToStringFunction = recordToStringFunction;
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }

    public TreeNodeInfoExtractor<RECORD> getTreeNodeInfoExtractor() {
        return this.treeNodeInfoExtractor;
    }

    public void setTreeNodeInfoExtractor(TreeNodeInfoExtractor<RECORD> treeNodeInfoExtractor) {
        this.treeNodeInfoExtractor = treeNodeInfoExtractor;
    }
}

