/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiInfiniteItemView;
import org.teamapps.dto.UiMediaDeviceInfo;
import org.teamapps.dto.UiMediaSoupPublishingParameters;
import org.teamapps.dto.UiMediaSoupV2PlaybackParameters;
import org.teamapps.dto.UiMediaSoupV2WebRtcClient;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.WebRtcPublishingFailureReason;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.webrtc.AudioTrackConstraints;
import org.teamapps.ux.component.webrtc.MulticastPlaybackProfile;
import org.teamapps.ux.component.webrtc.PublishedStreamsStatus;
import org.teamapps.ux.component.webrtc.ScreenSharingConstraints;
import org.teamapps.ux.component.webrtc.VideoTrackConstraints;
import org.teamapps.ux.component.webrtc.WebRtcStreamType;
import org.teamapps.ux.session.SessionContext;

public class MediaSoupV2WebRtcClient
extends AbstractComponent {
    public final Event<MulticastPlaybackProfile> onPlaybackProfileChanged = new Event();
    public final Event<Boolean> onVoiceActivityChanged = new Event();
    public final Event<Void> onClicked = new Event();
    public final Event<Void> onPublishingSucceeded = new Event();
    public final Event<PublishedStreamsStatus> onPublishedStreamsStatusChanged = new Event();
    public final Event<WebRtcPublishingFailureReason> onPublishingFailed = new Event();
    public final Event<WebRtcStreamType> onPublishedStreamEnded = new Event();
    public final Event<Void> onPlaybackSucceeded = new Event();
    public final Event<Void> onPlaybackFailed = new Event();
    public final Event<Boolean> onConnectionStateChanged = new Event();
    private String serverAddress;
    private boolean activityLineVisible;
    private Color activityInactiveColor;
    private Color activityActiveColor;
    private boolean active;
    private List<Icon> icons = Collections.emptyList();
    private String caption;
    private String noVideoImageUrl;
    private Float displayAreaAspectRatio;
    private double playbackVolume = 1.0;
    private UiObject lastPublishOrPlaybackParams;
    private Supplier<Component> contextMenuProvider = null;
    private int lastSeenContextMenuRequestId;

    public MediaSoupV2WebRtcClient() {
    }

    public MediaSoupV2WebRtcClient(String serverUrl) {
        this.serverAddress = serverUrl;
    }

    public UiMediaSoupV2WebRtcClient createUiComponent() {
        UiMediaSoupV2WebRtcClient ui = new UiMediaSoupV2WebRtcClient();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setInitialPlaybackOrPublishParams((Object)this.lastPublishOrPlaybackParams);
        ui.setActivityLineVisible(this.activityLineVisible);
        ui.setActivityInactiveColor(UiUtil.createUiColor(this.activityInactiveColor));
        ui.setActivityActiveColor(UiUtil.createUiColor(this.activityActiveColor));
        ui.setIcons(this.icons.stream().map(icon -> this.getSessionContext().resolveIcon((Icon)icon)).collect(Collectors.toList()));
        ui.setCaption(this.caption);
        ui.setNoVideoImageUrl(this.noVideoImageUrl);
        ui.setDisplayAreaAspectRatio(this.displayAreaAspectRatio);
        ui.setPlaybackVolume(this.playbackVolume);
        ui.setContextMenuEnabled(this.contextMenuProvider != null);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_PROFILE_CHANGED: {
                UiMediaSoupV2WebRtcClient.PlaybackProfileChangedEvent e = (UiMediaSoupV2WebRtcClient.PlaybackProfileChangedEvent)event;
                if (e.getProfile() == null) {
                    return;
                }
                MulticastPlaybackProfile profile = Arrays.stream(MulticastPlaybackProfile.values()).filter(p -> Objects.equals(p.name(), e.getProfile().name())).findFirst().orElse(null);
                if (profile == null) {
                    return;
                }
                this.onPlaybackProfileChanged.fire(MulticastPlaybackProfile.valueOf(e.getProfile().name()));
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED: {
                UiMediaSoupV2WebRtcClient.VoiceActivityChangedEvent e = (UiMediaSoupV2WebRtcClient.VoiceActivityChangedEvent)event;
                this.onVoiceActivityChanged.fire(e.getActive());
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CLICKED: {
                UiMediaSoupV2WebRtcClient.ClickedEvent e = (UiMediaSoupV2WebRtcClient.ClickedEvent)event;
                this.onClicked.fire();
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHING_SUCCEEDED: {
                this.onPublishingSucceeded.fire();
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHED_STREAMS_STATUS_CHANGED: {
                UiMediaSoupV2WebRtcClient.PublishedStreamsStatusChangedEvent e = (UiMediaSoupV2WebRtcClient.PublishedStreamsStatusChangedEvent)event;
                this.onPublishedStreamsStatusChanged.fire(new PublishedStreamsStatus(e.getAudio(), e.getVideo()));
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHING_FAILED: {
                this.onPublishingFailed.fire(((UiMediaSoupV2WebRtcClient.PublishingFailedEvent)event).getReason());
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHED_STREAM_ENDED: {
                this.onPublishedStreamEnded.fire(((UiMediaSoupV2WebRtcClient.PublishedStreamEndedEvent)event).getIsDisplay() ? WebRtcStreamType.DISPLAY : WebRtcStreamType.CAM_MIC);
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_SUCCEEDED: {
                this.onPlaybackSucceeded.fire();
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_FAILED: {
                this.onPlaybackFailed.fire();
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CONNECTION_STATE_CHANGED: {
                this.onConnectionStateChanged.fire(((UiMediaSoupV2WebRtcClient.ConnectionStateChangedEvent)event).getConnected());
                break;
            }
            case UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CONTEXT_MENU_REQUESTED: {
                UiMediaSoupV2WebRtcClient.ContextMenuRequestedEvent e = (UiMediaSoupV2WebRtcClient.ContextMenuRequestedEvent)event;
                this.lastSeenContextMenuRequestId = e.getRequestId();
                if (this.contextMenuProvider != null) {
                    Component contextMenuContent = this.contextMenuProvider.get();
                    if (contextMenuContent != null) {
                        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetContextMenuContentCommand(this.getId(), e.getRequestId(), contextMenuContent.createUiReference()));
                        break;
                    }
                    this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), e.getRequestId()));
                    break;
                }
                this.closeContextMenu();
                break;
            }
        }
    }

    public void publish(String streamUuid, String token, AudioTrackConstraints audioConstraints, VideoTrackConstraints videoConstraints, ScreenSharingConstraints screenSharingConstraints, long maxBitrate) {
        UiMediaSoupPublishingParameters params = new UiMediaSoupPublishingParameters();
        params.setUrl(this.serverAddress);
        params.setStreamUuid(streamUuid);
        params.setToken(token);
        params.setAudioConstraints(audioConstraints != null ? audioConstraints.createUiAudioTrackConstraints() : null);
        params.setVideoConstraints(videoConstraints != null ? videoConstraints.createUiVideoTrackConstraints() : null);
        params.setScreenSharingConstraints(screenSharingConstraints != null ? screenSharingConstraints.createUiScreenSharingConstraints() : null);
        params.setMaxBitrate(maxBitrate);
        if (this.isRendered()) {
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.PublishCommand(this.getId(), params));
        } else {
            this.lastPublishOrPlaybackParams = params;
        }
    }

    public void play(String streamUuid, boolean audio, boolean video, long minBitrate, long maxBitrate) {
        UiMediaSoupV2PlaybackParameters params = new UiMediaSoupV2PlaybackParameters();
        params.setUrl(this.serverAddress);
        params.setStreamUuid(streamUuid);
        params.setAudio(audio);
        params.setVideo(video);
        params.setMinBitrate(minBitrate);
        params.setMaxBitrate(maxBitrate);
        if (this.isRendered()) {
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.PlaybackCommand(this.getId(), params));
        } else {
            this.lastPublishOrPlaybackParams = params;
        }
    }

    public void stop() {
        if (this.isRendered()) {
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.StopCommand(this.getId()));
        } else {
            this.lastPublishOrPlaybackParams = null;
        }
    }

    private void update() {
        this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public boolean isActivityLineVisible() {
        return this.activityLineVisible;
    }

    public void setActivityLineVisible(boolean activityLineVisible) {
        this.activityLineVisible = activityLineVisible;
        this.update();
    }

    public Color getActivityInactiveColor() {
        return this.activityInactiveColor;
    }

    public void setActivityInactiveColor(Color activityInactiveColor) {
        this.activityInactiveColor = activityInactiveColor;
        this.update();
    }

    public Color getActivityActiveColor() {
        return this.activityActiveColor;
    }

    public void setActivityActiveColor(Color activityActiveColor) {
        this.activityActiveColor = activityActiveColor;
        this.update();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            this.queueCommandIfRendered(() -> new UiMediaSoupV2WebRtcClient.SetActiveCommand(this.getId(), active));
        }
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<Icon> icons) {
        if (icons == null) {
            icons = Collections.emptyList();
        }
        if (!Objects.equals(icons, this.icons)) {
            this.icons = icons;
            this.update();
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        if (!Objects.equals(caption, this.caption)) {
            this.caption = caption;
            this.update();
        }
    }

    public String getNoVideoImageUrl() {
        return this.noVideoImageUrl;
    }

    public void setNoVideoImageUrl(String noVideoImageUrl) {
        if (!Objects.equals(noVideoImageUrl, this.noVideoImageUrl)) {
            this.noVideoImageUrl = noVideoImageUrl;
            this.update();
        }
    }

    public Float getDisplayAreaAspectRatio() {
        return this.displayAreaAspectRatio;
    }

    public void setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
        if (!Objects.equals(displayAreaAspectRatio, this.displayAreaAspectRatio)) {
            this.displayAreaAspectRatio = displayAreaAspectRatio;
            this.update();
        }
    }

    public double getPlaybackVolume() {
        return this.playbackVolume;
    }

    public void setPlaybackVolume(double playbackVolume) {
        if (playbackVolume != this.playbackVolume) {
            this.playbackVolume = playbackVolume;
            this.update();
        }
    }

    public static CompletableFuture<List<UiMediaDeviceInfo>> enumerateDevices() {
        CompletableFuture<List<UiMediaDeviceInfo>> future = new CompletableFuture<List<UiMediaDeviceInfo>>();
        SessionContext.current().queueCommand(new UiMediaSoupV2WebRtcClient.EnumerateDevicesCommand(), value -> future.complete((List<UiMediaDeviceInfo>)value));
        return future;
    }

    public Supplier<Component> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Supplier<Component> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), this.lastSeenContextMenuRequestId));
    }
}

