/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.floating;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiFloatingComponent;
import org.teamapps.event.Event;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.floating.FloatingPosition;

public class FloatingComponent
extends AbstractComponent {
    public final Event<Boolean> onExpandedOrCollapsed = new Event();
    private final Component containerComponent;
    private Component contentComponent;
    private int width = -1;
    private int height = -1;
    private int marginX;
    private int marginY;
    private FloatingPosition position;
    private Color backgroundColor = Color.TRANSPARENT;
    private Color expanderHandleColor = Color.WHITE;
    private boolean collapsible;
    private boolean expanded;

    public FloatingComponent(Component containerComponent, Component contentComponent) {
        this.containerComponent = containerComponent;
        this.contentComponent = contentComponent;
    }

    @Override
    public UiComponent createUiComponent() {
        UiFloatingComponent ui = new UiFloatingComponent();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setContainerComponent(this.containerComponent.createUiReference());
        ui.setContentComponent(Component.createUiClientObjectReference(this.contentComponent));
        ui.setWidth(this.width);
        ui.setHeight(this.height);
        ui.setMarginX(this.marginX);
        ui.setMarginY(this.marginY);
        ui.setPosition(this.position.toUiPosition());
        ui.setBackgroundColor(UiUtil.createUiColor(this.backgroundColor));
        ui.setExpanderHandleColor(UiUtil.createUiColor(this.expanderHandleColor));
        ui.setCollapsible(this.collapsible);
        ui.setExpanded(this.expanded);
        return ui;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetDimensionsCommand(this.getId(), width, this.height));
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetDimensionsCommand(this.getId(), this.width, height));
    }

    public int getMarginX() {
        return this.marginX;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetMarginsCommand(this.getId(), marginX, this.marginY));
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetMarginsCommand(this.getId(), this.marginX, marginY));
    }

    public FloatingPosition getPosition() {
        return this.position;
    }

    public void setPosition(FloatingPosition position) {
        this.position = position;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetPositionCommand(this.getId(), position.toUiPosition()));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetBackgroundColorCommand(this.getId(), UiUtil.createUiColor(backgroundColor)));
    }

    public Color getExpanderHandleColor() {
        return this.expanderHandleColor;
    }

    public void setExpanderHandleColor(Color expanderHandleColor) {
        this.expanderHandleColor = expanderHandleColor;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetExpanderHandleColorCommand(this.getId(), UiUtil.createUiColor(expanderHandleColor)));
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetExpandedCommand(this.getId(), expanded));
    }

    public Component getContentComponent() {
        return this.contentComponent;
    }

    public void setContentComponent(Component contentComponent) {
        this.contentComponent = contentComponent;
        this.queueCommandIfRendered(() -> new UiFloatingComponent.SetContentComponentCommand(this.getId(), contentComponent != null ? contentComponent.createUiReference() : null));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_FLOATING_COMPONENT_EXPANDED_OR_COLLAPSED: {
                this.onExpandedOrCollapsed.fire(((UiFloatingComponent.ExpandedOrCollapsedEvent)event).getExpanded());
            }
        }
    }
}

