/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.notification;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiNotificationBar;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.notification.NotificationBarItem;
import org.teamapps.ux.component.notification.NotificationBarItemClosedEvent;

public class NotificationBar
extends AbstractComponent {
    public final Event<NotificationBarItemClosedEvent> onItemClosed = new Event();
    public final Event<NotificationBarItem> onItemClicked = new Event();
    private final Map<String, NotificationBarItem> itemsByUiId = new HashMap<String, NotificationBarItem>();

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_NOTIFICATION_BAR_ITEM_CLICKED: {
                UiNotificationBar.ItemClickedEvent e = (UiNotificationBar.ItemClickedEvent)event;
                NotificationBarItem item = this.itemsByUiId.get(e.getId());
                item.onClicked.fire();
                this.onItemClicked.fire(item);
                break;
            }
            case UI_NOTIFICATION_BAR_ITEM_CLOSED: {
                UiNotificationBar.ItemClosedEvent e = (UiNotificationBar.ItemClosedEvent)event;
                NotificationBarItem item = this.itemsByUiId.get(e.getId());
                NotificationBarItemClosedEvent.ClosingReason reason = e.getWasTimeout() ? NotificationBarItemClosedEvent.ClosingReason.TIMEOUT : NotificationBarItemClosedEvent.ClosingReason.USER;
                item.onClosed.fire(reason);
                this.onItemClosed.fire(new NotificationBarItemClosedEvent(item, reason));
                break;
            }
        }
    }

    @Override
    public UiComponent createUiComponent() {
        UiNotificationBar ui = new UiNotificationBar();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        return ui;
    }

    public void addItem(NotificationBarItem item, EntranceAnimation entranceAnimation, ExitAnimation exitAnimation) {
        this.itemsByUiId.put(item.getUiId(), item);
        this.queueCommandIfRendered(() -> new UiNotificationBar.AddItemCommand(this.getId(), item.toUiNotificationBarItem(), entranceAnimation.toUiEntranceAnimation(), exitAnimation.toUiExitAnimation()));
    }

    public void removeItem(NotificationBarItem item) {
        this.itemsByUiId.remove(item.getUiId());
        this.queueCommandIfRendered(() -> new UiNotificationBar.RemoveItemCommand(this.getId(), item.getUiId(), null));
    }
}

