/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import java.io.InputStream;
import org.teamapps.ux.resource.Resource;

public class ClassPathResource
implements Resource {
    private final String resourceName;
    private final String name;
    private final ClassLoader classLoader;
    private long length = -1L;

    public ClassPathResource(String resourceName) {
        this(resourceName, null);
    }

    public ClassPathResource(String resourceName, ClassLoader classLoader) {
        this.resourceName = resourceName;
        this.name = resourceName.contains("/") ? resourceName.substring(resourceName.lastIndexOf(47) + 1) : resourceName;
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getInputStream() {
        InputStream is;
        if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(this.resourceName);
        } else {
            is = this.getClass().getResourceAsStream(this.resourceName);
            if (is == null) {
                is = ClassLoader.getSystemResourceAsStream(this.resourceName);
            }
        }
        return is;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLength() {
        if (this.length < 0L) {
            this.length = Resource.super.getLength();
        }
        return this.length;
    }

    public String toString() {
        return "ClassPathResource{resourceName='" + this.resourceName + "'}";
    }
}

