/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;

public final class Fields {
    private Fields() {
    }

    public static boolean validateAll(AbstractField<?> ... fields) {
        return Fields.validateAll(Arrays.stream(fields));
    }

    public static boolean validateAll(List<AbstractField<?>> fields) {
        return Fields.validateAll(fields.stream());
    }

    public static boolean validateAll(Stream<AbstractField<?>> stream) {
        List errorMessage = stream.flatMap(field -> field.validate().stream()).filter(message -> message.getSeverity() == FieldMessage.Severity.ERROR).collect(Collectors.toList());
        return errorMessage.size() == 0;
    }
}

