/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentGridPlacement;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiGridLayout;
import org.teamapps.dto.UiGridPlacement;
import org.teamapps.dto.UiGridRow;
import org.teamapps.dto.UiResponsiveGridLayout;
import org.teamapps.dto.UiResponsiveGridLayoutPolicy;
import org.teamapps.dto.UiSizeType;
import org.teamapps.dto.UiSizingPolicy;
import org.teamapps.dto.UiSpacing;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishBreakpoint;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishPlacement;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishRow;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishSizing;
import org.teamapps.ux.component.grid.layout.GridColumn;

public class BootstrapishGridLayout
extends AbstractComponent
implements Container {
    private static final int DEFAULT_NUMBER_OF_COLUMNS = 12;
    private boolean fillHeight = false;
    private final List<GridColumn> columns = new ArrayList<GridColumn>();
    private final List<BootstrapishRow> rows = new ArrayList<BootstrapishRow>();
    private Map<BootstrapishBreakpoint, Integer> responsiveBreakpointMinWidths = new EnumMap<BootstrapishBreakpoint, Integer>(BootstrapishBreakpoint.class);
    private int gridGap = 5;
    private VerticalElementAlignment verticalItemAlignment = VerticalElementAlignment.STRETCH;
    private HorizontalElementAlignment horizontalItemAlignment = HorizontalElementAlignment.STRETCH;

    public BootstrapishGridLayout() {
        this(12);
    }

    public BootstrapishGridLayout(int numberOfColumns) {
        this(IntStream.range(0, numberOfColumns).mapToObj(i -> new GridColumn(SizingPolicy.FRACTION)).collect(Collectors.toList()));
    }

    public BootstrapishGridLayout(List<GridColumn> columnDefinitions) {
        Arrays.stream(BootstrapishBreakpoint.values()).forEach(bootstrapishBreakpoint -> this.responsiveBreakpointMinWidths.put((BootstrapishBreakpoint)((Object)bootstrapishBreakpoint), bootstrapishBreakpoint.getDefaultMinWidth()));
        this.columns.addAll(columnDefinitions);
    }

    @Override
    public UiComponent createUiComponent() {
        UiResponsiveGridLayout uiResponsiveGridLayout = new UiResponsiveGridLayout(this.createUiLayoutPolicies());
        this.mapAbstractUiComponentProperties((UiComponent)uiResponsiveGridLayout);
        uiResponsiveGridLayout.setFillHeight(this.fillHeight);
        return uiResponsiveGridLayout;
    }

    private List<UiResponsiveGridLayoutPolicy> createUiLayoutPolicies() {
        Set usedResponsiveBreakpoints = this.rows.stream().flatMap(row -> row.getPlacements().stream()).flatMap(placement -> placement.getSizings().keySet().stream()).collect(Collectors.toSet());
        return usedResponsiveBreakpoints.stream().map(breakpoint -> {
            List uiGridColumns = this.columns.stream().map(c -> c.createUiGridColumn()).collect(Collectors.toList());
            List<UiGridPlacement> uiGridPlacements = this.createUiGridPlacements((BootstrapishBreakpoint)((Object)breakpoint));
            Integer maxUiRowIndex = uiGridPlacements.stream().map(uiGridPlacement -> uiGridPlacement.getRow()).max(Integer::compareTo).orElse(0);
            List uiGridRows = IntStream.rangeClosed(0, maxUiRowIndex).mapToObj(i -> new UiGridRow().setHeightPolicy(new UiSizingPolicy(UiSizeType.AUTO))).collect(Collectors.toList());
            UiGridLayout uiGridLayout = new UiGridLayout(uiGridColumns, uiGridRows, uiGridPlacements).setPadding(new UiSpacing().setTop((float)(this.gridGap / 2)).setRight((float)(this.gridGap / 2)).setBottom((float)(this.gridGap / 2)).setLeft((float)(this.gridGap / 2))).setGridGap(this.gridGap).setVerticalAlignment(this.verticalItemAlignment != null ? this.verticalItemAlignment.toUiVerticalElementAlignment() : null).setHorizontalAlignment(this.horizontalItemAlignment != null ? this.horizontalItemAlignment.toUiHorizontalElementAlignment() : null);
            return new UiResponsiveGridLayoutPolicy(this.responsiveBreakpointMinWidths.get(breakpoint).intValue(), uiGridLayout);
        }).collect(Collectors.toList());
    }

    private List<UiGridPlacement> createUiGridPlacements(BootstrapishBreakpoint breakpoint) {
        ArrayList<UiGridPlacement> uiPlacements = new ArrayList<UiGridPlacement>();
        int uiRowIndex = 0;
        int rowIndex = 0;
        while (rowIndex < this.rows.size()) {
            int currentColumnIndex = 0;
            for (BootstrapishPlacement placement : this.rows.get(rowIndex).getPlacements()) {
                int colSpan;
                BootstrapishSizing sizing = placement.getSizingForBreakPoint(breakpoint);
                int n = colSpan = sizing.getColSpan() == -1 ? this.columns.size() : sizing.getColSpan();
                if (sizing.getOffset() + colSpan > this.columns.size()) {
                    throw new IllegalArgumentException("Offset + colspan > numberOfColumns");
                }
                int rightmostSpannedColIndex = currentColumnIndex + sizing.getOffset() + colSpan - 1;
                if (rightmostSpannedColIndex >= this.columns.size()) {
                    ++uiRowIndex;
                    currentColumnIndex = 0;
                }
                uiPlacements.add((UiGridPlacement)new UiComponentGridPlacement(placement.getComponent().createUiReference()).setRow(uiRowIndex).setColumn(currentColumnIndex + sizing.getOffset()).setColSpan(colSpan).setHorizontalAlignment(placement.getHorizontalAlignment() != null ? placement.getHorizontalAlignment().toUiHorizontalElementAlignment() : null).setVerticalAlignment(placement.getVerticalAlignment() != null ? placement.getVerticalAlignment().toUiVerticalElementAlignment() : null));
                currentColumnIndex += sizing.getOffset() + colSpan;
            }
            ++rowIndex;
            ++uiRowIndex;
        }
        return uiPlacements;
    }

    public void refreshLayout() {
        this.queueCommandIfRendered(() -> new UiResponsiveGridLayout.UpdateLayoutPoliciesCommand(this.getId(), this.createUiLayoutPolicies()));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public void setColumns(List<GridColumn> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public List<GridColumn> getColumns() {
        return this.columns;
    }

    public List<BootstrapishRow> getRows() {
        return this.rows;
    }

    public void setRows(List<BootstrapishRow> rows) {
        this.rows.clear();
        this.rows.addAll(rows);
    }

    public BootstrapishGridLayout addRow(BootstrapishRow row) {
        this.rows.add(row);
        return this;
    }

    public BootstrapishRow.ChainBuilder addRow() {
        return new BootstrapishRow.ChainBuilder(this);
    }

    public boolean isFillHeight() {
        return this.fillHeight;
    }

    public void setFillHeight(boolean fillHeight) {
        this.fillHeight = fillHeight;
        this.queueCommandIfRendered(() -> new UiResponsiveGridLayout.SetFillHeightCommand(this.getId(), fillHeight));
    }

    public Map<BootstrapishBreakpoint, Integer> getResponsiveBreakpointMinWidths() {
        return this.responsiveBreakpointMinWidths;
    }

    public void setResponsiveBreakpointMinWidths(Map<BootstrapishBreakpoint, Integer> responsiveBreakpointMinWidths) {
        this.responsiveBreakpointMinWidths = responsiveBreakpointMinWidths;
        this.refreshLayout();
    }

    public int getGridGap() {
        return this.gridGap;
    }

    public void setGridGap(int gridGap) {
        this.gridGap = gridGap;
        this.refreshLayout();
    }

    public VerticalElementAlignment getVerticalItemAlignment() {
        return this.verticalItemAlignment;
    }

    public void setVerticalItemAlignment(VerticalElementAlignment verticalItemAlignment) {
        this.verticalItemAlignment = verticalItemAlignment;
        this.refreshLayout();
    }

    public HorizontalElementAlignment getHorizontalItemAlignment() {
        return this.horizontalItemAlignment;
    }

    public void setHorizontalItemAlignment(HorizontalElementAlignment horizontalItemAlignment) {
        this.horizontalItemAlignment = horizontalItemAlignment;
        this.refreshLayout();
    }
}

