/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.forcelayout;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiNetworkLink;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutNode;

public class ForceLayoutLink<RECORD> {
    private final ForceLayoutNode<RECORD> source;
    private final ForceLayoutNode<RECORD> target;
    private float lineWidth = 1.0f;
    private Color lineColor = Color.MATERIAL_GREY_500;
    private String lineDashArray;

    public ForceLayoutLink(ForceLayoutNode<RECORD> source, ForceLayoutNode<RECORD> target) {
        this.source = source;
        this.target = target;
    }

    public UiNetworkLink toUiNetworkLink() {
        UiNetworkLink ui = new UiNetworkLink(this.source.getId(), this.target.getId());
        ui.setLineWidth(this.lineWidth);
        ui.setLineColor(this.lineColor != null ? this.lineColor.toHtmlColorString() : null);
        ui.setLineDashArray(this.lineDashArray);
        return ui;
    }

    public ForceLayoutNode<RECORD> getSource() {
        return this.source;
    }

    public ForceLayoutNode<RECORD> getTarget() {
        return this.target;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public String getLineDashArray() {
        return this.lineDashArray;
    }

    public void setLineDashArray(String lineDashArray) {
        this.lineDashArray = lineDashArray;
    }
}

