/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.combobox;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiComboBox;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.combobox.AbstractComboBox;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;

public class ComboBox<RECORD>
extends AbstractComboBox<ComboBox, RECORD, RECORD>
implements TextInputHandlingField {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComboBox.class);
    public final Event<String> onFreeTextEntered = new Event();
    private String freeTextEntry;

    public ComboBox() {
    }

    public ComboBox(ComboBoxModel<RECORD> model) {
        super(model);
    }

    public ComboBox(Template template) {
        this.setTemplate(template);
    }

    public static <R> ComboBox<R> createForList(List<R> staticData) {
        return ComboBox.createForList(staticData, null);
    }

    public static <R> ComboBox<R> createForList(List<R> staticData, Template template) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setModel(query -> staticData.stream().filter(record -> comboBox.getRecordToStringFunction().apply(record).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    public static <ENUM extends Enum> ComboBox<ENUM> createForEnum(Class<ENUM> enumClass) {
        return ComboBox.createForList(Arrays.asList((Enum[])enumClass.getEnumConstants()));
    }

    public UiField createUiComponent() {
        UiComboBox comboBox = new UiComboBox();
        this.mapCommonUiComboBoxProperties(comboBox);
        return comboBox;
    }

    @Override
    public void setValue(RECORD record) {
        super.setValue(record);
        this.freeTextEntry = null;
    }

    @Override
    public RECORD convertUiValueToUxValue(Object value) {
        this.freeTextEntry = null;
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            this.freeTextEntry = null;
            Object record = this.recordCache.getRecordByClientId((Integer)value);
            return record;
        }
        if (value instanceof String) {
            String freeText = (String)value;
            if (this.freeTextRecordFactory != null) {
                Object record = this.freeTextRecordFactory.apply(freeText);
                this.recordCache.replaceRecords(Collections.singletonList(record)).commit();
            } else {
                this.freeTextEntry = freeText;
            }
            this.onFreeTextEntered.fire(freeText);
            return null;
        }
        throw new IllegalArgumentException("Unknown ui value type: " + value);
    }

    @Override
    public Object convertUxValueToUiValue(RECORD record) {
        if (record == null) {
            return null;
        }
        CacheManipulationHandle handle = this.recordCache.addRecord(record);
        handle.commit();
        return handle.getAndClearResult();
    }

    public String getFreeText() {
        return this.freeTextEntry;
    }
}

