/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.gridtemplate;

import java.util.Collections;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiTemplateElement;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.VerticalElementAlignment;

public abstract class AbstractTemplateElement<C extends AbstractTemplateElement> {
    protected String dataKey;
    protected int row;
    protected int column;
    protected int rowSpan = 1;
    protected int colSpan = 1;
    protected HorizontalElementAlignment horizontalAlignment = HorizontalElementAlignment.STRETCH;
    protected VerticalElementAlignment verticalAlignment = VerticalElementAlignment.CENTER;
    protected Spacing margin;
    protected Color backgroundColor;

    public AbstractTemplateElement(String dataKey) {
        this.dataKey = dataKey;
    }

    public AbstractTemplateElement(String dataKey, int row, int column) {
        this.dataKey = dataKey;
        this.row = row;
        this.column = column;
    }

    public AbstractTemplateElement(String dataKey, int row, int column, int rowSpan, int colSpan) {
        this.dataKey = dataKey;
        this.row = row;
        this.column = column;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
    }

    public AbstractTemplateElement(String dataKey, int row, int column, int rowSpan, int colSpan, HorizontalElementAlignment horizontalAlignment, VerticalElementAlignment verticalAlignment) {
        this.dataKey = dataKey;
        this.row = row;
        this.column = column;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }

    public C setRow(int row) {
        this.row = row;
        return (C)this;
    }

    public C setColumn(int column) {
        this.column = column;
        return (C)this;
    }

    public C setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return (C)this;
    }

    public C setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return (C)this;
    }

    public C setDataKey(String dataKey) {
        this.dataKey = dataKey;
        return (C)this;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public List<String> getDataKeys() {
        return Collections.singletonList(this.dataKey);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public HorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public AbstractTemplateElement<C> setHorizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public VerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public AbstractTemplateElement<C> setVerticalAlignment(VerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public Spacing getMargin() {
        return this.margin;
    }

    public AbstractTemplateElement<C> setMargin(Spacing margin) {
        this.margin = margin;
        return this;
    }

    public abstract AbstractUiTemplateElement createUiTemplateElement();

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public AbstractTemplateElement<C> setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    protected void mapAbstractTemplateElementAttributesToUiElement(AbstractUiTemplateElement uiElement) {
        uiElement.setRowSpan(this.rowSpan);
        uiElement.setColSpan(this.colSpan);
        uiElement.setHorizontalAlignment(this.horizontalAlignment.toUiHorizontalElementAlignment());
        uiElement.setVerticalAlignment(this.verticalAlignment.toUiVerticalElementAlignment());
        uiElement.setMargin(this.margin != null ? this.margin.createUiSpacing() : null);
        uiElement.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
    }
}

