/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.Collections;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiLineChartDataDisplay;
import org.teamapps.dto.UiLineChartLine;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartDataDisplayChangeListener;

public class LineChartLine
extends AbstractLineChartDataDisplay {
    private final String dataSeriesId;
    private LineChartCurveType graphType = LineChartCurveType.MONOTONE;
    private float dataDotRadius = 2.0f;
    private Color lineColorScaleMin = new Color(73, 128, 192);
    private Color lineColorScaleMax = new Color(73, 128, 192);
    private Color areaColorScaleMin = new Color(255, 255, 255, 0.0f);
    private Color areaColorScaleMax = new Color(255, 255, 255, 0.0f);

    public LineChartLine(String dataSeriesId) {
        this.dataSeriesId = dataSeriesId;
    }

    public LineChartLine(String dataSeriesId, LineChartCurveType graphType, float dataDotRadius, Color lineColor) {
        this(dataSeriesId, graphType, dataDotRadius, lineColor, lineColor, null, null);
    }

    public LineChartLine(String dataSeriesId, LineChartCurveType graphType, float dataDotRadius, Color lineColor, Color areaColor) {
        this(dataSeriesId, graphType, dataDotRadius, lineColor, lineColor, Color.withAlpha((Color)areaColor, (float)0.0f), areaColor);
    }

    public LineChartLine(String dataSeriesId, LineChartCurveType graphType, float dataDotRadius, Color lineColorScaleMin, Color lineColorScaleMax, Color areaColorScaleMin, Color areaColorScaleMax) {
        this.dataSeriesId = dataSeriesId;
        this.graphType = graphType;
        this.dataDotRadius = dataDotRadius;
        this.lineColorScaleMin = lineColorScaleMin;
        this.lineColorScaleMax = lineColorScaleMax;
        this.areaColorScaleMin = areaColorScaleMin;
        this.areaColorScaleMax = areaColorScaleMax;
    }

    public UiLineChartLine createUiFormat() {
        UiLineChartLine ui = new UiLineChartLine();
        this.mapAbstractLineChartDataDisplayProperties((AbstractUiLineChartDataDisplay)ui);
        ui.setDataSeriesId(this.dataSeriesId);
        ui.setGraphType(this.graphType.toUiLineChartCurveType());
        ui.setDataDotRadius(this.dataDotRadius);
        ui.setLineColorScaleMin(this.lineColorScaleMin != null ? this.lineColorScaleMin.toHtmlColorString() : null);
        ui.setLineColorScaleMax(this.lineColorScaleMax != null ? this.lineColorScaleMax.toHtmlColorString() : null);
        ui.setAreaColorScaleMin(this.areaColorScaleMin != null ? this.areaColorScaleMin.toHtmlColorString() : null);
        ui.setAreaColorScaleMax(this.areaColorScaleMax != null ? this.areaColorScaleMax.toHtmlColorString() : null);
        return ui;
    }

    @Override
    public List<String> getDataSeriesIds() {
        return Collections.singletonList(this.dataSeriesId);
    }

    public LineChartCurveType getGraphType() {
        return this.graphType;
    }

    public LineChartLine setGraphType(LineChartCurveType graphType) {
        this.graphType = graphType;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public float getDataDotRadius() {
        return this.dataDotRadius;
    }

    public LineChartLine setDataDotRadius(float dataDotRadius) {
        this.dataDotRadius = dataDotRadius;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getLineColorScaleMin() {
        return this.lineColorScaleMin;
    }

    public LineChartLine setLineColorScaleMin(Color lineColorScaleMin) {
        this.lineColorScaleMin = lineColorScaleMin;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getLineColorScaleMax() {
        return this.lineColorScaleMax;
    }

    public LineChartLine setLineColorScaleMax(Color lineColorScaleMax) {
        this.lineColorScaleMax = lineColorScaleMax;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getAreaColorScaleMin() {
        return this.areaColorScaleMin;
    }

    public LineChartLine setAreaColorScaleMin(Color areaColorScaleMin) {
        this.areaColorScaleMin = areaColorScaleMin;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getAreaColorScaleMax() {
        return this.areaColorScaleMax;
    }

    public LineChartLine setAreaColorScaleMax(Color areaColorScaleMax) {
        this.areaColorScaleMax = areaColorScaleMax;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    @Override
    public void setChangeListener(LineChartDataDisplayChangeListener listener) {
        this.changeListener = listener;
    }
}

