/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.partitioning;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.teamapps.ux.component.timegraph.partitioning.TimePartitionUnit;
import org.teamapps.ux.component.timegraph.partitioning.TimedDataPartition;

public class TimedDataPartitioner {
    public static List<TimedDataPartition> partition(long startTime, long endTime, List<Long> eventTimeStamps, ZoneId zoneId, TimePartitionUnit partitionUnit, boolean returnEmptyPartitions) {
        return TimedDataPartitioner.partition(startTime, endTime, eventTimeStamps.stream().mapToLong(l -> l).toArray(), zoneId, partitionUnit, returnEmptyPartitions);
    }

    public static List<TimedDataPartition> partition(long startTime, long endTime, long[] eventTimeStamps, ZoneId zoneId, TimePartitionUnit partitionUnit, boolean returnEmptyPartitions) {
        TreeMap<Long, Integer> partitions = new TreeMap<Long, Integer>(Comparator.comparingLong(value -> value));
        if (returnEmptyPartitions) {
            ZonedDateTime partitionZonedDateTime = Instant.ofEpochMilli(TimedDataPartitioner.getPartition(startTime, zoneId, partitionUnit)).atZone(zoneId);
            while (partitionZonedDateTime.toInstant().toEpochMilli() <= endTime) {
                partitions.put(partitionZonedDateTime.toInstant().toEpochMilli(), 0);
                partitionZonedDateTime = partitionUnit.increment(partitionZonedDateTime);
            }
        }
        long searchStartTime = partitionUnit.getPartition(Instant.ofEpochMilli(startTime).atZone(zoneId)).toInstant().toEpochMilli();
        ZonedDateTime endTimeZonedDateTime = Instant.ofEpochMilli(endTime).atZone(zoneId);
        long searchEndTime = partitionUnit.increment(partitionUnit.increment(partitionUnit.getPartition(endTimeZonedDateTime))).toInstant().toEpochMilli();
        Arrays.stream(eventTimeStamps).filter(e -> e >= searchStartTime && e <= searchEndTime).forEach(e -> partitions.compute(TimedDataPartitioner.getPartition(e, zoneId, partitionUnit), (partition, count) -> count == null ? 1 : count + 1));
        return partitions.entrySet().stream().map(entry -> new TimedDataPartition((Long)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }

    private static long getPartition(Long eventTime, ZoneId zoneId, TimePartitionUnit partitionUnit) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(eventTime).atZone(zoneId);
        return partitionUnit.getPartition(zonedDateTime).toInstant().toEpochMilli();
    }
}

